<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Helper\AuthenticationHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Virtueplanet\Plugin\System\Prime\Helper\GoogleFontHelper;
use Virtueplanet\Plugin\System\Prime\Helper\TemplateHelper;

/** @var Joomla\CMS\Document\HtmlDocument $this */
$extraButtons = AuthenticationHelper::getLoginButtons('form-login');

/** @var Joomla\CMS\Document\HtmlDocument $this */
/** @var \Joomla\CMS\Application\SiteApplication $app */
$app = Factory::getApplication();
$wa  = $this->getWebAssetManager();

/** @var Joomla\Registry\Registry $params */
$params = $this->params;

// Detecting Active Variables
$option    = strtolower($app->input->getCmd('option', ''));
$view      = strtolower($app->input->getCmd('view', ''));
$layout    = strtolower($app->input->getCmd('layout', ''));
$task      = strtolower($app->input->getCmd('task', ''));
$itemid    = $app->input->getInt('Itemid', 0);
$tmpl      = strtolower($app->input->getCmd('tmpl', ''));
$manage    = $app->input->getInt('manage', 0);
$sitename  = htmlspecialchars($app->get('sitename'), ENT_QUOTES, 'UTF-8');
$menu      = $app->getMenu()->getActive();
$pageclass = $menu !== null ? $menu->getParams()->get('pageclass_sfx', '') : '';
$version   = TemplateHelper::getVersionFromManifest(__DIR__ . '/templateDetails.xml');
$template  = $app->getTemplate(false);
$bodyClass = ($option ? ' ' . str_replace('_', '-', $option) : '') .
    ($view ? ' view-' . $view : ' no-view') .
    ($layout ? ' layout-' . $layout : ' no-layout') .
    ($task ? ' task-' . $task : ' no-task') .
    ($itemid ? ' itemid-' . $itemid : '') .
    ($pageclass ? ' ' . $pageclass : '') .
    ($this->direction === 'rtl' ? ' rtl' : ' ltr') .
    (' tpl-' . str_replace('_', '-', $template)) .
    (' v-' . $version) .
    (' j-' . substr(JVERSION, 0, 1));

$fullWidth = 1;

// Use a font scheme if set in the template style options
$paramsFontScheme = $params->get('use_font_scheme', false);

if ($paramsFontScheme) {
    if ($paramsFontScheme === 'google') {
        $bodyFontName       = $params->get('google_font_name', '');
        $bodyFontVariant    = $params->get('google_font_variant', '');
        $addFontVariants    = $params->get('google_font_additional_variants', []);
        $headingFontName    = $params->get('heading_google_font_name', '');
        $headingFontVariant = $params->get('heading_google_font_variant', '');
        $gfontsJsonFile     = 'media/templates/site/vp_neoteric/webfonts/gfonts.json';
        $fontStyles         = '';

        if ($bodyFontName || $headingFontName) {
            $this->getPreloadManager()->preconnect('https://fonts.googleapis.com/', ['crossorigin' => 'anonymous']);
            $this->getPreloadManager()->preconnect('https://fonts.gstatic.com/', ['crossorigin' => 'anonymous']);

            if ($bodyFontName) {
                GoogleFontHelper::addFontFamily($bodyFontName, $bodyFontVariant);

                if (!empty($addFontVariants)) {
                    GoogleFontHelper::addFontFamily($bodyFontName, $addFontVariants);
                }

                $fontInfo = GoogleFontHelper::getFontInfo($bodyFontName, $bodyFontVariant, $gfontsJsonFile);

                if ($fontInfo) {
                    $fontStyles .= '--neoteric-font-family-body: ' . $fontInfo->family . ";\n";
                    $fontStyles .= '--neoteric-font-weight-normal: ' . $fontInfo->weight . ";\n";
                    $fontStyles .= '--neoteric-font-style-normal: ' . $fontInfo->style . ";\n";
                }
            }

            if ($headingFontName) {
                GoogleFontHelper::addFontFamily($headingFontName, $headingFontVariant);

                $fontInfo = GoogleFontHelper::getFontInfo($headingFontName, $headingFontVariant, $gfontsJsonFile);

                if ($fontInfo) {
                    $fontStyles .= '--neoteric-font-family-headings: ' . $fontInfo->family . ";\n";
                    $fontStyles .= '--neoteric-font-weight-headings: ' . $fontInfo->weight . ";\n";
                    $fontStyles .= '--neoteric-font-style-headings: ' . $fontInfo->style . ";\n";
                }
            }

            $fontStyleUrl = GoogleFontHelper::getAddedFontsUrl();

            if ($fontStyleUrl) {
                $this->getPreloadManager()->preload($fontStyleUrl, ['as' => 'style', 'crossorigin' => 'anonymous']);

                if ($params->get('lazyload_google_fonts', 1)) {
                    $wa->registerAndUseStyle('fontscheme.current', $fontStyleUrl, [], ['media' => 'print', 'rel' => 'lazy-stylesheet', 'onload' => 'this.media=\'all\'', 'crossorigin' => 'anonymous']);
                } else {
                    $wa->registerAndUseStyle('fontscheme.current', $fontStyleUrl, [], ['media' => 'all', 'crossorigin' => 'anonymous']);
                }
            }
        }

        if (!empty($fontStyles)) {
            $wa->addInlineStyle(":root {\n" . $fontStyles . "}");
        }
    } else {
        $wa->registerAndUseStyle('fontscheme.current', $paramsFontScheme, ['version' => 'auto'], ['media' => 'all']);
        $this->getPreloadManager()->preload($wa->getAsset('style', 'fontscheme.current')->getUri() . '?' . $this->getMediaVersion(), ['as' => 'style']);
    }
}

// Enable assets
$wa->usePreset('template.vp_neoteric.' . ($this->direction === 'rtl' ? 'rtl' : 'ltr'))
    ->useStyle('template.active.language')
    ->useStyle('template.offline')
    ->useStyle('template.user')
    ->useScript('template.user');

// Add CSS variables
$cssVariables    = TemplateHelper::getCSSVariables($params, __DIR__, 'style');
$cssVariablesStr = '';

foreach ($cssVariables as $name => $value) {
    $cssVariablesStr .= $name . ': ' . $value . ';' . "\n";
}

$cssVariablesStr = ':root {' . "\n" . $cssVariablesStr . '}';

$wa->addInlineStyle($cssVariablesStr);

// Override 'template.active' asset to set correct ltr/rtl dependency
$wa->registerStyle('template.active', '', [], [], ['template.vp_neoteric.' . ($this->direction === 'rtl' ? 'rtl' : 'ltr')]);

// Browsers support SVG favicons
$this->addHeadLink(HTMLHelper::_('image', 'joomla-favicon.svg', '', [], true, 1), 'icon', 'rel', ['type' => 'image/svg+xml']);
$this->addHeadLink(HTMLHelper::_('image', 'favicon.ico', '', [], true, 1), 'alternate icon', 'rel', ['type' => 'image/vnd.microsoft.icon']);
$this->addHeadLink(HTMLHelper::_('image', 'joomla-favicon-pinned.svg', '', [], true, 1), 'mask-icon', 'rel', ['color' => '#000']);

// Logo file or site title param
if ($params->get('logo_file')) {
    $logo = '<img src="' . Uri::root(true) . '/' . htmlspecialchars($params->get('logo_file'), ENT_QUOTES) . '" alt="' . $sitename . '">';
} elseif ($params->get('site_title')) {
    $logo = '<span title="' . $sitename . '">' . htmlspecialchars($params->get('site_title'), ENT_COMPAT, 'UTF-8') . '</span>';
} else {
    $logo = HTMLHelper::_('image', 'logo.svg', $sitename, ['class' => 'logo d-inline-block'], true, 0);
}

// Defer font awesome
$wa->getAsset('style', 'fontawesome')->setAttribute('rel', 'lazy-stylesheet');
?>
<!DOCTYPE html>
<html lang="<?php echo $this->language; ?>" dir="<?php echo $this->direction; ?>">

<head>
    <jdoc:include type="metas" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <jdoc:include type="styles" />
    <jdoc:include type="scripts" />
</head>

<body class="site offline-site<?php echo $bodyClass; ?>">
    <div class="outer">
        <div class="offline-card">
            <div class="header">
                <?php if (!empty($logo)) : ?>
                    <h1><?php echo $logo; ?></h1>
                <?php else : ?>
                    <h1><?php echo $sitename; ?></h1>
                <?php endif; ?>
                <?php if ($app->get('offline_image')) : ?>
                    <?php echo HTMLHelper::_('image', $app->get('offline_image'), $sitename, [], false, 0); ?>
                <?php endif; ?>
                <?php if ($app->get('display_offline_message', 1) == 1 && str_replace(' ', '', $app->get('offline_message')) != '') : ?>
                    <p><?php echo $app->get('offline_message'); ?></p>
                <?php elseif ($app->get('display_offline_message', 1) == 2) : ?>
                    <p><?php echo Text::_('JOFFLINE_MESSAGE'); ?></p>
                <?php endif; ?>
            </div>
            <div class="login">
                <jdoc:include type="message" />
                <form action="<?php echo Route::_('index.php', true); ?>" method="post" id="form-login">
                    <fieldset>
                        <label for="username"><?php echo Text::_('JGLOBAL_USERNAME'); ?></label>
                        <input name="username" class="form-control" id="username" type="text">

                        <label for="password"><?php echo Text::_('JGLOBAL_PASSWORD'); ?></label>
                        <input name="password" class="form-control" id="password" type="password">

                        <?php foreach ($extraButtons as $button) :
                            $dataAttributeKeys = array_filter(array_keys($button), function ($key) {
                                return substr($key, 0, 5) == 'data-';
                            });
                            ?>
                            <div class="mod-login__submit form-group">
                                <button type="button" class="btn btn-secondary w-100 mt-4 <?php echo $button['class'] ?? '' ?>" <?php foreach ($dataAttributeKeys as $key) :
                                    ?> <?php echo $key ?>="<?php echo $button[$key] ?>" <?php
                                                                                          endforeach; ?> <?php if ($button['onclick']) :
    ?> onclick="<?php echo $button['onclick'] ?>" <?php
                                                                                          endif; ?> title="<?php echo Text::_($button['label']) ?>" id="<?php echo $button['id'] ?>">
                                    <?php if (!empty($button['icon'])) : ?>
                                        <span class="<?php echo $button['icon'] ?>"></span>
                                    <?php elseif (!empty($button['image'])) : ?>
                                        <?php echo $button['image']; ?>
                                    <?php elseif (!empty($button['svg'])) : ?>
                                        <?php echo $button['svg']; ?>
                                    <?php endif; ?>
                                    <?php echo Text::_($button['label']) ?>
                                </button>
                            </div>
                        <?php endforeach; ?>

                        <button type="submit" name="Submit" class="btn btn-primary"><?php echo Text::_('JLOGIN'); ?></button>

                        <input type="hidden" name="option" value="com_users">
                        <input type="hidden" name="task" value="user.login">
                        <input type="hidden" name="return" value="<?php echo base64_encode(Uri::base()); ?>">
                        <?php echo HTMLHelper::_('form.token'); ?>
                    </fieldset>
                </form>
            </div>
        </div>
    </div>
</body>

</html>
