/*
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

var vmValidator = window.vmValidator || {};

(function (vmValidator, Virtuemart, document, window, $, undefined) {
    vmValidator.validate = function (form, isRegistration) {
        var registrationFields = ['username', 'name', 'password', 'password2'];
        var recaptchaWrapper = form.querySelector('#recaptcha_wrapper');
        var prefix = '';

        if (form.virtuemart_userinfo_id && form.virtuemart_userinfo_id.value) {
            registrationFields = [];
        }

        if (typeof Virtuemart !== typeof undefined && typeof Virtuemart.regfields !== typeof undefined) {
            registrationFields = Virtuemart.regfields;
        }

        if (typeof Virtuemart !== typeof undefined && typeof Virtuemart.prefiks !== typeof undefined) {
            prefix = Virtuemart.prefiks;
        }

        for (var i = 0; i < registrationFields.length; i++) {
            [].slice.call(form.querySelectorAll('[name="' + registrationFields[i] + '"]')).forEach(function (field) {
                if (isRegistration) {
                    field.required = true;
                    field.classList.add('required');
                } else {
                    field.required = false;
                    field.classList.remove('required');
                }
            });
        }

        if (recaptchaWrapper && vmValidator._isHiddenElement(recaptchaWrapper)) {
            if (isRegistration) {
                vmValidator._showElement(recaptchaWrapper);
            } else {
                vmValidator._hideElement(recaptchaWrapper);
            }
        }

        var countryField = form.querySelector('[name="' + prefix + 'virtuemart_country_id"]');
        var stateField = form.querySelector('[name="' + prefix + 'virtuemart_state_id"]');

        if (stateField && (typeof stateField.dataset.required === typeof undefined || stateField.dataset.required === null)) {
            if (stateField.required || stateField.classList.contains('required')) {
                stateField.required = false;
                stateField.classList.remove('required');
                stateField.dataset.required = true;
            } else {
                stateField.dataset.required = false;
            }

            if (typeof $ !== typeof undefined) {
                $(stateField).off('change', vmValidator._revalidateCountryStateField);
                $(stateField).on('change', vmValidator._revalidateCountryStateField);
            }
        }

        if (countryField && typeof $ !== typeof undefined) {
            $(countryField).off('change', vmValidator._revalidateCountryStateField);
            $(countryField).on('change', vmValidator._revalidateCountryStateField);
        }

        return document.formvalidator.isValid(form);
    }

    vmValidator._revalidateCountryStateField = function (event) {
        document.formvalidator.validate(event.target);
    }

    vmValidator._isHiddenElement = function (element) {
        if (!element) {
            return false;
        }

        if (window.getComputedStyle(element).display === 'none' || window.getComputedStyle(element).visibility === 'hidden') {
            return true;
        }

        return false;
    }

    vmValidator._showElement = function (element) {
        if (!element) {
            return false;
        }

        element.style.display = '';
        element.style.visibility = '';
    }

    vmValidator._hideElement = function (element) {
        if (!element) {
            return false;
        }

        element.style.display = 'none';
        element.style.visibility = 'hidden';
    }

})(vmValidator, Virtuemart, document, window, jQuery);

const myValidator = function (form, isRegistration) {
    return vmValidator.validate(form, isRegistration);
}
