/*
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

var Virtuemart = window.Virtuemart || {};

(function ($, Virtuemart) {

    Virtuemart.stopSendtocart = false;
    Virtuemart.ajaxPool = {};
    Virtuemart.dialog = null;
    Virtuemart.dialogModal = null;

    Virtuemart.setproducttype = function (form, id) {
        form.view = null;
        var datas = form.serialize();

        var runs = 0,
            maxruns = 20,
            container = form.closest('[data-vm="product-child-container"]');

        if (!container.length) {
            container = form.closest('[data-vm="product-container"]');
        }

        if (!container.length) {
            container = form;

            while (!container.hasClass('product-container') && !container.hasClass('productdetails') && !container.hasClass('vm-product-details-container') && runs <= maxruns) {
                container = container.parent();
                runs++;
            }

            if (runs > maxruns) {
                console.log('setproducttype: Could not find parent container product-container nor product-field-display');
                return false;
            }
        }

        var prices = container.find(':not([data-vm="product-container"]) [data-vm="product-prices"], :not([data-vm="product-container"]) .product-price');

        if (!prices.length) {
            prices = $('#productPrice' + id);
        }

        datas = datas.replace('&view=cart', '');

        prices.fadeTo('fast', 0.75);

        if (Virtuemart.ajaxPool.hasOwnProperty('setproducttype') && Virtuemart.ajaxPool['setproducttype'].readystate != 4) {
            Virtuemart.ajaxPool['setproducttype'].abort();
        }

        Virtuemart.ajaxPool['setproducttype'] = $.ajax({
            type: 'POST',
            cache: false,
            dataType: 'json',
            url: Virtuemart.vmSiteurl + 'index.php?option=com_virtuemart&view=productdetails&task=recalculate&format=json&nosef=1' + Virtuemart.vmLang,
            data: datas
        }).done(function (data, textStatus) {
            prices.fadeTo('fast', 1);
            // Remove previous messages generated by this AJAX call:
            $('#system-message-container #system-message div.vmprices-message').remove();

            // Refresh price
            for (var key in data) {
                var value = data[key];

                if (key === 'messages') {
                    var newmessages = $(data[key]).find('div.alert').addClass('vmprices-message');

                    if (!$('#system-message-container #system-message').length && newmessages.length) {
                        $('#system-message-container').append('<div id="system-message"></div>');
                    }

                    newmessages.appendTo('#system-message-container #system-message');
                } else {
                    if (value) {
                        if (key == 'discountAmount' && value.indexOf('-') >= 0) {
                            value = value.replace('-', '');
                        }

                        prices.find('span.Price' + key).show().html(value);
                    } else {
                        prices.find('.Price' + key).html(0).hide();
                    }
                }
            }
        });

        return false;
    }

    Virtuemart.productUpdate = function () {
        $('body').trigger('updateVirtueMartCartModule');
        $(document).trigger('updateVirtueMartCartModule');
    }

    Virtuemart.eventsetproducttype = function (event) {
        Virtuemart.setproducttype(event.data.cart, event.data.virtuemart_product_id);
    }

    Virtuemart.sendtocart = function (form) {
        if (Virtuemart.addtocart_popup == 1) {
            Virtuemart.cartEffect(form);
        } else {
            form.append('<input type="hidden" name="task" value="add" />');
            form.submit();
        }
    }

    Virtuemart.cartEffect = function (form) {
        if (Virtuemart.ajaxPool.hasOwnProperty('add') && Virtuemart.ajaxPool['add'].readystate != 4) {
            Virtuemart.ajaxPool['add'].abort();
        }

        Virtuemart.ajaxPool['add'] = $.ajax({
            type: 'POST',
            cache: false,
            dataType: 'json',
            timeout: '20000',
            url: Virtuemart.vmSiteurl + 'index.php?option=com_virtuemart&nosef=1&view=cart&task=addJS&format=json' + Virtuemart.vmLang + window.Itemid,
            data: form.serialize(),
            beforeSend: function () {
                Virtuemart.startVmLoading();
            },
            success: function (data) {
                var title, headerClass;

                if (typeof data.msg == 'string') {
                    data.msg = $.parseHTML(data.msg);
                }

                var $message = $(data.msg);

                if (data.stat == 1) {
                    title = Joomla.Text._('COM_VIRTUEMART_PRODUCT_ADDED_SUCCESSFULLY');
                    headerClass = 'bg-info text-white';
                } else if (data.stat == 2) {
                    title = Joomla.Text._('WARNING');
                    headerClass = 'bg-warning text-white';
                } else {
                    title = Joomla.Text._('COM_VIRTUEMART_MINICART_ERROR_JS');
                    headerClass = 'bg-danger text-white';
                }

                Virtuemart.getDialog({
                    title: title,
                    content: $message.find('.cart-popup-content').clone(),
                    headerClass: headerClass,
                    cartButton: $message.find('.cart-popup-buttons > .cart-link').clone(),
                    continueButton: $message.find('.cart-popup-buttons > .continue-link').clone(),
                    large: $message.find('.cart-popup-related-products').length
                }).show();

                Virtuemart.stopVmLoading();

                $('body').trigger('updateVirtueMartCartModule');
            },
            error: function () {
                Virtuemart.stopVmLoading();
            }
        });
    }

    Virtuemart.dataFB = function (dom, name) {
        var value;

        if (dom.is('[data-' + name + ']')) {
            value = parseInt(dom.attr('data-' + name));
        } else {
            value = parseInt(dom.attr(name));
        }

        return value;
    }

    Virtuemart.incrQuantity = function (event) {
        var rParent = $(this).closest('td, .addtocart-bar, form'),
            quantity = rParent.find('input[name^="quantity["]'),
            virtuemart_product_id = rParent.find('input[name="virtuemart_product_id[]"]').val();

        var step = Virtuemart.dataFB(quantity, 'step');

        if (isNaN(step)) {
            step = 1;
        }

        var qty = parseInt(quantity.val());

        if (!isNaN(qty)) {
            quantity.val(qty + step);

            var maxQty = Virtuemart.dataFB(quantity, 'max');

            if (!isNaN(maxQty) && quantity.val() > maxQty) {
                quantity.val(maxQty);
            }

            if (!isNaN(virtuemart_product_id)) {
                Virtuemart.setproducttype(event.data.cart, virtuemart_product_id);
            } else {
                Virtuemart.updFormS();
            }
        }
    }

    Virtuemart.decrQuantity = function (event) {
        var rParent = $(this).closest('td, .addtocart-bar, form'),
            quantity = rParent.find('input[name^="quantity["]'),
            virtuemart_product_id = rParent.find('input[name="virtuemart_product_id[]"]').val();

        var step = Virtuemart.dataFB(quantity, 'step');

        if (isNaN(step)) {
            step = 1;
        }

        var minQty = Virtuemart.dataFB(quantity, 'init');

        if (isNaN(minQty)) {
            minQty = 1;
        }

        var qty = parseInt(quantity.val());

        if (!isNaN(qty) && qty > step) {
            quantity.val(qty - step);

            if (!isNaN(minQty) && quantity.val() < minQty) {
                quantity.val(minQty);
            }
        } else {
            quantity.val(minQty);
        }

        if (!isNaN(virtuemart_product_id)) {
            Virtuemart.setproducttype(event.data.cart, virtuemart_product_id);
        } else {
            Virtuemart.updFormS();
        }
    }

    Virtuemart.addtocart = function (event) {
        if (!event) {
            event = window.event;
        }

        event.preventDefault();

        if (!Virtuemart.quantityErrorAlert(event)) {
            return false;
        }

        if (event.hasOwnProperty('stopSendtocart') && event.stopSendtocart == true) {
            return false;
        }

        var target;

        if (event.target) {
            target = event.target;
        } else if (event.srcElement) {
            target = event.srcElement;
        }

        // Defeat Safari bug
        if (target.nodeType == 3) {
            target = target.parentNode;
        }

        if (Virtuemart.isQuickview()) {
            window.parent.Virtuemart.sendtocart(event.data.cart);
        } else {
            Virtuemart.sendtocart(event.data.cart);
        }

        return false;
    }

    Virtuemart.isQuickview = function () {
        var insideIframe = false;

        try {
            insideIframe = window.self !== window.parent;
        } catch (e) {
            insideIframe = true;
        }

        if (insideIframe && typeof window.parent.Virtuemart !== typeof undefined && typeof window.parent.Virtuemart.sendtocart === 'function') {
            return true;
        }

        return false;
    }

    Virtuemart.quantityErrorAlert = function (event) {
        event.preventDefault();

        var $me = $(this);

        if ($me.is('input')) {
            var step = Virtuemart.dataFB($me, 'step');

            return Virtuemart.checkQuantity(this, step, $me.attr('data-errStr'));
        }

        return true;
    }

    Virtuemart.product = function (carts) {
        carts.each(function () {
            var $cart = $(this),
                virtuemart_product_id = $cart.find('input[name="virtuemart_product_id[]"]').val();

            this.action = "#";

            $cart.find('.quantity-plus').off('click', Virtuemart.incrQuantity).on('click', {
                cart: $cart
            }, Virtuemart.incrQuantity);

            $cart.find('.quantity-minus').off('click', Virtuemart.decrQuantity).on('click', {
                cart: $cart
            }, Virtuemart.decrQuantity);

            $cart.find('select:not(.no-vm-bind)').off('change', Virtuemart.eventsetproducttype).on('change', {
                cart: $cart,
                virtuemart_product_id: virtuemart_product_id
            }, Virtuemart.eventsetproducttype);

            $cart.find('input:radio:not(.no-vm-bind)').off('change', Virtuemart.eventsetproducttype).on('change', {
                cart: $cart,
                virtuemart_product_id: virtuemart_product_id
            }, Virtuemart.eventsetproducttype);

            $cart.find('.quantity-input')
                .off('click blur submit', Virtuemart.quantityErrorAlert)
                .on('click blur submit', Virtuemart.quantityErrorAlert)
                .off('keyup', Virtuemart.eventsetproducttype)
                .on('keyup', {
                    cart: $cart,
                    virtuemart_product_id: virtuemart_product_id
                }, Virtuemart.eventsetproducttype);

            $cart.find('button[name="addtocart"], input[name="addtocart"], a[name="addtocart"]').off('click submit', Virtuemart.addtocart).on('click submit', {
                cart: $cart
            }, Virtuemart.addtocart);
        });
    }

    Virtuemart.checkQuantity = function (obj, step, myStr) {
        // use the modulus operator "%" to see if there is a remainder
        var remainder = obj.value % step,
            quantity = obj.value;

        if (remainder != 0) {
            if (!isNaN(myStr)) {
                alert(myStr.replace("%s", step));
            }

            if (quantity != remainder && quantity > remainder) {
                obj.value = quantity - remainder;
            } else {
                obj.value = step;
            }

            return false;
        }

        return true;
    }

    Virtuemart.getDialog = function (params) {
        if (Virtuemart.dialogModal) {
            Virtuemart.dialogModal.dispose();
        }

        if (Virtuemart.dialog) {
            Virtuemart.dialog.remove();
        }

        var defaultParams = {
            title: '',
            content: '',
            cartButton: '',
            continueButton: '',
            headerClass: '',
            large: false
        };

        params = $.extend(true, {}, defaultParams, params);

        Virtuemart.dialog = $('<div></div>')
            .addClass('modal')
            .addClass('fade')
            .addClass('virtuemart-dialog')
            .attr('id', 'virtuemart-dialog')
            .attr('tabindex', '-1')
            .attr('aria-labelledby', 'virtuemart-dialog-label')
            .attr('aria-hidden', 'true');
        var $modalDialog = $('<div></div>').addClass('modal-dialog');

        if (params.large) {
            $modalDialog.addClass('modal-lg');
        }

        var $modalContent = $('<div></div>').addClass('modal-content');

        if (params.title) {
            var $modalHeader = $('<div></div>').addClass('modal-header');

            $modalHeader.addClass('justify-content-between');

            var $modalTitle = $('<h5></h5>').addClass('modal-title fs-5').html(params.title);
            var $closeButtonContainer = $('<div></div>').addClass('close-button-container d-flex justify-content-end');
            var $closeButton = $('<button></button>').attr('type', 'button').addClass('btn-close').attr('data-bs-dismiss', 'modal').attr('aria-label', 'Close');

            $closeButtonContainer.html($closeButton);

            if (params.headerClass) {
                $modalHeader.addClass(params.headerClass);
            }

            $modalHeader.append($modalTitle).append($closeButtonContainer);
            $modalContent.append($modalHeader);
        }

        $('<div></div>').addClass('modal-body').html(params.content).appendTo($modalContent);

        if (params.cartButton || params.continueButton) {
            var $footer = $('<div></div>').addClass('modal-footer');

            $footer.addClass('justify-content-center');

            if (params.continueButton) {
                $footer.append(params.continueButton);
            }

            if (params.cartButton) {
                $footer.append(params.cartButton);
            }

            $modalContent.append($footer);
        }

        $modalDialog.html($modalContent);
        Virtuemart.dialog.html($modalDialog);

        $('body').append(Virtuemart.dialog);

        Virtuemart.dialogModal = new bootstrap.Modal(Virtuemart.dialog[0]);

        return Virtuemart.dialogModal;
    }
})(jQuery, Virtuemart);
