/*
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

var Virtuemart = window.Virtuemart || {};

(function ($, Virtuemart) {

    Virtuemart.findContainers = function (event) {
        var container = $(event.currentTarget).closest('.product-field-display'),
            defaultSelector = Virtuemart.containerSelector,
            targetContainer;

        if (!container.length) {
            console.log('CV: Could not find parent container product-field-display');
            return false;
        }

        Virtuemart.container = container;

        Virtuemart.containerSelector = '[data-vm="product-container"]:not([data-ignore-dynamic])';

        targetContainer = Virtuemart.container.closest(Virtuemart.containerSelector);

        if (!targetContainer.length) {
            Virtuemart.containerSelector = defaultSelector ? defaultSelector : Virtuemart.containerSelector;
            targetContainer = Virtuemart.container.closest(Virtuemart.containerSelector);

            if (!targetContainer.length) {
                console.log('CV: Could not find product-container ' + defaultSelector, container);
                return false;
            }
        }

        Virtuemart.container = targetContainer;

        return container;
    }

    Virtuemart.cvFind = function (event) {
        event.preventDefault();
        var selection = [];

        var container = Virtuemart.findContainers(event);
        var found = false;

        // We check first if it is a radio
        $(container).find('input.cvselection:checked').each(function () {
            selection[selection.length] = $(this).val();
            found = true;
        });

        if (!found) {
            $(container).find('select.cvselection').each(function () {
                selection[selection.length] = $(this).val();
            });
        }

        var index = 0, i2 = 0, hitcount = 0;

        // to ensure that an url is set, set the url of first product
        $(this).prop('url', event.data.variants[0][0]);

        for (var runs = 0; runs < selection.length; index++) {
            for (index = 0; index < event.data.variants.length; index++) {
                hitcount = 0;

                for (i2 = 0; i2 <= selection.length; i2++) {
                    if (selection[i2] == event.data.variants[index][i2 + 1]) {
                        hitcount++;
                        if (hitcount == (selection.length - runs)) {
                            var url = event.data.variants[index][0].replace(/amp;/g, '');

                            $(this).attr('url', url);
                            $(this).val(url);

                            if ($(this).attr('reload') || $(this).attr('data-reload')) {
                                Virtuemart.isUpdatingContent = true;
                                $(this).vm2front("startVmLoading");
                                window.top.location.href = url;

                                return false;
                            }

                            return url;
                        }
                    } else {
                        break;
                    }
                }
            }
            runs++;
        }

        return false;
    };

    Virtuemart.avFind = function (event) {
        Virtuemart.findContainers(event);
    }

})(jQuery, Virtuemart);
