<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Virtueplanet\Plugin\System\Prime\Helper\VirtuemartHelper;

defined('_JEXEC') or die;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app        = Factory::getApplication();
$document   = $app->getDocument();
$active     = $app->input->getInt('active', 0);
$ocClassSfx = $document->getType() === 'json' && $active ? ' show' : '';
?>
<div class="vme-mod-compare <?php echo $class_sfx ?>">
    <div class="vme-mod-inner">
        <div class="vme-mod-contents">
            <div class="vme-mod__anchor">
                <a class="d-inline-block link-inherit-color btn-icon" data-bs-toggle="offcanvas" href="#compareOffcanvas<?php echo $module->id; ?>" role="button" aria-controls="compareOffcanvas<?php echo $module->id; ?>" title="<?php echo Text::_('MOD_VME_COMPARE_COMPARE'); ?>">
                    <span class="jewel-group">
                        <i class="vpi vpi-random vpi-lg d-inline-block align-middle" aria-hidden="true"></i>
                        <span class="visually-hidden"><?php echo Text::_('MOD_VME_COMPARE_COMPARE'); ?></span>
                        <span class="vme-mod__product-count jewel">
                            <?php echo (int) $count; ?>
                        </span>
                    </span>
                </a>
            </div>
            <div class="vme-mod__offcanvas-container text-color-body">
                <div class="offcanvas offcanvas-end<?php echo $ocClassSfx; ?>" tabindex="-1" id="compareOffcanvas<?php echo $module->id; ?>" aria-labelledby="compareOffcanvas<?php echo $module->id; ?>-Label">
                    <div class="offcanvas-header px-3">
                        <h5 class="offcanvas-title" id="compareOffcanvas<?php echo $module->id; ?>-Label">
                            <?php echo Text::_('MOD_VME_COMPARE_COMPARE'); ?>
                        </h5>
                        <button type="button" class="btn-icon btn-hover" data-bs-dismiss="offcanvas" aria-label="Close">
                            <i class="vpi vpi-times vpi-lg" aria-hidden="true"></i>
                        </button>
                    </div>
                    <div class="vme-mod__contents has-mod-loader">
                        <?php if (!empty($count)) : ?>
                            <div class="offcanvas-body p-0">
                                <?php foreach ($products as $key => $product) : ?>
                                    <div class="p-3 vme-mod__product-details">
                                        <div class="row g-3">
                                            <div class="col-3">
                                                <a href="<?php echo Route::_(VirtuemartHelper::getProductUrl($product)); ?>" class="vme-mod__product-thumbnail">
                                                    <?php echo !empty($product->images[0]) ? $product->images[0]->displayMediaThumb('', false) : ''; ?>
                                                </a>
                                            </div>
                                            <div class="col-8">
                                                <strong><?php echo HTMLHelper::link(Route::_(VirtuemartHelper::getProductUrl($product)), $product->product_name, ['class' => 'link-body']); ?></strong>
                                                <?php if ($params->get('show_price', 1) && $currency->_priceConfig['salesPrice'][0]) : ?>
                                                    <div class="mod-product-price text-color-primary">
                                                        <?php echo $currency->priceDisplay($product->prices['salesPrice']); ?>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                            <div class="col-1">
                                                <form action="<?php echo Route::_('index.php?option=com_vmessentials&view=compare') ?>" method="post" class="vmessentials-form">
                                                    <button type="submit" class="vme-mod__remove btn-remove" title="<?php echo Text::_('MOD_VME_COMPARE_REMOVE') ?>" <?php echo $use_ajax ? ' data-vmecompareremove' : ''; ?>>
                                                        <span aria-hidden="true">&times;</span><span class="sr-only"><?php echo Text::_('MOD_VME_COMPARE_REMOVE') ?></span>
                                                    </button>
                                                    <input type="hidden" name="option" value="com_vmessentials" />
                                                    <input type="hidden" name="task" value="compare.remove" />
                                                    <input type="hidden" name="virtuemart_product_id" value="<?php echo (int) $product->virtuemart_product_id; ?>" />
                                                    <input type="hidden" name="product_name" value="<?php echo htmlspecialchars($product->product_name, ENT_COMPAT, 'UTF-8'); ?>" />
                                                    <?php echo HTMLHelper::_('form.token'); ?>
                                                    <?php echo HTMLHelper::_('vmessentials.returnUri'); ?>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                            <div class="vme-mod__show-link-container px-3 py-4">
                                <a href="<?php echo $url; ?>" class="btn btn-primary w-100">
                                    <?php echo Text::_('COM_VMESSENTIALS_GO_TO_COMPARE'); ?>
                                </a>
                            </div>
                        <?php else : ?>
                            <div class="vme-mod__empty d-flex flex-column justify-content-center align-items-center text-center py-5 px-3">
                                <div class="empty-icon text-center">
                                    <i class="fas fa-random" aria-hidden="true" tabindex="-1"></i>
                                </div>
                                <p class="empty-heading text-center">
                                    <?php echo Text::_('MOD_VME_COMPARE_EMPTY_COMPARE'); ?>
                                </p>
                            </div>
                        <?php endif; ?>
                        <div class="vme-mod-loader vme-hide" aria-hidden="true" tabindex="-1"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>