<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Virtueplanet\Plugin\System\Prime\Helper\VirtuemartHelper;

defined('_JEXEC') or die;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app  = Factory::getApplication();
$wa   = $app->getDocument()->getWebAssetManager();
$list = VirtuemartHelper::getCurrencies();

HTMLHelper::_('bootstrap.dropdown', '.dropdown-toggle');

if (!isset($module) && function_exists('debug_backtrace')) {
    foreach (debug_backtrace() as $step) {
        if (isset($step['function']) && $step['function'] === 'dispatch' && isset($step['object'])) {
            $reflection = new ReflectionClass($step['object']);

            if ($reflection->hasProperty('module')) {
                $property = $reflection->getProperty('module');

                $property->setAccessible(true);

                $module = $property->getValue($step['object']);

                break;
            }
        }
    }
}

vmJsApi::jQuery();
vmJsApi::chosenDropDowns();

if (!empty($module->position) && in_array($module->position, ['top-left', 'top-right'])) {
    $wa->addInlineScript("
    document.addEventListener('DOMContentLoaded', function () {
        document.querySelector('#currency_picker_des_" . $module->id . "').querySelectorAll('a').forEach(function (link) {
            link.addEventListener('click', function (event) {
                event.preventDefault();
                var form = event.target.closest('form');
                form.querySelector('input.virtuemart-currency-id').value = event.target.dataset.id;
                form.submit();
            });
        });
    });
    ");
} else {
    $js = "
    jQuery(document).ready(function($) {
        $('.changeSendForm').off('change', Virtuemart.sendCurrForm).on('change', Virtuemart.sendCurrForm);
    })";
    vmJsApi::addJScript('sendFormChange', $js);
}
?>
<div class="vm-currency-selector">
    <form action="<?php echo vmURI::getCurrentUrlBy('get', true) ?>" method="post">
        <?php if (!empty($text_before)) : ?>
            <span class="mod-virtuemart-currencies__pretext pretext"><?php echo $text_before; ?></span>
        <?php endif; ?>

        <?php if (!empty($module->position) && in_array($module->position, ['top-left', 'top-right'])) : ?>
            <a href="#" id="currency_btn_<?php echo $module->id; ?>" role="button" data-bs-toggle="dropdown" class="d-flex align-items-center gap-2 link-trigger link-inherit-color dropdown-toggle" aria-haspopup="listbox" aria-labelledby="currency_picker_des_<?php echo $module->id; ?> currency_btn_<?php echo $module->id; ?>" aria-expanded="false">
                <?php echo $list[$virtuemart_currency_id]->currency_code_3; ?>
            </a>

            <ul id="currency_picker_des_<?php echo $module->id; ?>" class="currency-block dropdown-menu">
                <?php foreach ($currencies as $currency) : ?>
                    <?php if (isset($list[$currency->virtuemart_currency_id])) : ?>
                        <?php $currency_code_3 = $list[$currency->virtuemart_currency_id]->currency_code_3; ?>
                        <?php $currency_name   =  $list[$currency->virtuemart_currency_id]->currency_name; ?>
                        <li<?php echo $currency->virtuemart_currency_id == $virtuemart_currency_id ? ' class="currency-active"' : ''; ?>>
                            <a class="link-body" href="#<?php echo $currency_code_3 ?>" class="select-me" data-id="<?php echo $currency->virtuemart_currency_id; ?>"><?php echo $currency_code_3; ?> - <?php echo $currency_name; ?></a>
                        </li>
                    <?php endif; ?>
                <?php endforeach; ?>
            </ul>

            <input type="hidden" name="virtuemart_currency_id" class="virtuemart-currency-id" value="<?php echo $virtuemart_currency_id; ?>" />
        <?php else : ?>
            <?php echo HTMLHelper::_('select.genericlist', $currencies, 'virtuemart_currency_id', 'class="changeSendForm inputbox vm-chzn-select"', 'virtuemart_currency_id', 'currency_txt', $virtuemart_currency_id) ; ?>
        <?php endif; ?>
    </form>
</div>
<?php echo vmJsApi::writeJS(); ?>
