<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;

defined('_JEXEC') or die;

// Initialize some variables
/** @var \Joomla\CMS\Application\SiteApplication $app */
$app       = Factory::getApplication();
$document  = $app->getDocument();
$product   = isset($displayData['product']) ? $displayData['product'] : null;
$params    = isset($displayData['params']) ? $displayData['params'] : $app->getParams('com_vmessentials');
$iconOnly  = isset($displayData['iconOnly']) ? $displayData['iconOnly'] : false;
$url       = isset($displayData['url']) ? $displayData['url'] : null;
$iconClass = isset($displayData['iconClass']) ? $displayData['iconClass'] : '';
$btnClass  = isset($displayData['btnClass']) ? $displayData['btnClass'] : '';
$tipPos    = $iconOnly ? ' data-bs-placement="left"' : '';

if ($document->getType() === 'html') {
    $document->getWebAssetManager()->usePreset('glightbox');
}
?>
<a href="#" data-target="<?php echo $url; ?>" class="has-tooltip <?php echo $btnClass ?>" target="_blank" rel="nofollow" title="<?php echo Text::_('COM_VMESSENTIALS_QUICKVIEW'); ?>" data-glightbox-link<?php echo $tipPos; ?>>
    <?php if (!empty($iconClass)) : ?>
        <i class="fas fa-search" aria-hidden="true"></i>
    <?php endif; ?>
    <span class="<?php echo $iconOnly ? 'visually-hidden' : 'vme-btn-text'; ?>"><?php echo Text::_('COM_VMESSENTIALS_QUICKVIEW'); ?></span>
</a>
