<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

defined('_JEXEC') or die;

// Initialize some variables
/** @var \Joomla\CMS\Application\SiteApplication $app */
$app       = Factory::getApplication();
$product   = isset($displayData['product']) ? $displayData['product'] : null;
$iconOnly  = isset($displayData['iconOnly']) ? $displayData['iconOnly'] : false;
$isAdded   = isset($displayData['isAdded']) ? $displayData['isAdded'] : false;
$params    = isset($displayData['params']) ? $displayData['params'] : $app->getParams('com_vmessentials');
$url       = isset($displayData['url']) ? $displayData['url'] : null;
$iconClass = isset($displayData['iconClass']) ? $displayData['iconClass'] : '';
$btnClass  = isset($displayData['btnClass']) ? $displayData['btnClass'] : '';
$dataAjax  = $params->get('ajax_compare', 1) ? ' data-vmecompare' : '';
$tipPos    = $iconOnly ? ' data-bs-placement="left"' : '';
?>
<a href="<?php echo $url ?>" class="btn-item-added vme-compare-link has-tooltip <?php echo $btnClass; ?><?php echo !$isAdded ? ' vme-hide' : ''; ?>" data-vmeid="<?php echo (int) $product->virtuemart_product_id; ?>" target="_top" title="<?php echo Text::_('COM_VMESSENTIALS_GO_TO_COMPARE'); ?>"<?php echo $tipPos; ?>>
    <?php if (!empty($iconClass)) : ?>
        <i class="fas fa-random" aria-hidden="true"></i>
    <?php endif; ?>
    <span class="<?php echo $iconOnly ? 'visually-hidden' : 'vme-btn-text'; ?>"><?php echo Text::_('COM_VMESSENTIALS_GO_TO_COMPARE'); ?></span>
</a>
<form action="<?php echo $url ?>" method="post" class="vmessentials-form vmessentials-compare-form<?php echo !$isAdded ? '' : ' vme-hide'; ?>">
    <button type="submit" class="has-tooltip vme-compare-button <?php echo $btnClass; ?>" <?php echo $dataAjax; ?> title="<?php echo Text::_('COM_VMESSENTIALS_ADD_TO_COMPARE'); ?>"<?php echo $tipPos; ?>>
        <?php if (!empty($iconClass)) : ?>
            <i class="fas fa-random" aria-hidden="true"></i>
        <?php endif; ?>
        <span class="<?php echo $iconOnly ? 'visually-hidden' : 'vme-btn-text'; ?>"><?php echo Text::_('COM_VMESSENTIALS_ADD_TO_COMPARE'); ?></span>
    </button>
    <input type="hidden" name="option" value="com_vmessentials" />
    <input type="hidden" name="task" value="compare.add" />
    <input type="hidden" name="virtuemart_product_id" value="<?php echo (int) $product->virtuemart_product_id; ?>" />
    <input type="hidden" name="product_name" value="<?php echo htmlspecialchars($product->product_name, ENT_COMPAT, 'UTF-8'); ?>" />
    <?php echo HTMLHelper::_('form.token'); ?>
    <?php echo HTMLHelper::_('vmessentials.returnUri'); ?>
</form>
