<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\Utilities\ArrayHelper;
use Virtueplanet\Plugin\System\Prime\Service\HTML\Module;

defined('_JEXEC') or die;

$module  = $displayData['module'];
$params  = $displayData['params'];
$attribs = $displayData['attribs'];

if ($module->content === null || $module->content === '') {
    return;
}

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app                          = Factory::getApplication();
/** @var Joomla\CMS\Document\HtmlDocument $document */
$document                     = $app->getDocument();
$moduleCount                  = $document->countModules($attribs['name'], true);
$bootstrapSize                = (int) $params->get('bootstrap_size', 0);
$moduleClass                  = $bootstrapSize !== 0 ? 'col-12 col-lg-' . $bootstrapSize : 'col-12 col-lg-' . floor(12 / $moduleCount);
$moduleTag                    = $params->get('module_tag', 'div');
$moduleAttribs                = [];
$moduleClassSuffix            = htmlspecialchars($params->get('moduleclass_sfx', ''), ENT_QUOTES, 'UTF-8');
$moduleAttribs['class']       = 'mod-position-' . $module->position . ' mod-row mb-5';
$moduleAttribs['data-mod-id'] = $module->id;
$headerTag                    = htmlspecialchars($params->get('header_tag', 'h3'), ENT_QUOTES, 'UTF-8');
$headerClass                  = htmlspecialchars($params->get('header_class', ''), ENT_QUOTES, 'UTF-8');
$headerAttribs                = [];
$headerAttribs['class']       = 'mod-title mod-row-title';
$subTitle                     = $params->get('vpprime_module_subtitle', '');
$subTitle                     = trim($subTitle);
$iconClass                    = $params->get('vpprime_module_icon_class', '');
$iconClass                    = trim($iconClass);
$badgeText                    = $params->get('vpprime_module_badge', '');
$badgeText                    = trim($badgeText);
$badgeBackground              = $params->get('vpprime_module_badge_background', '#ff0000');
$badgeColor                   = $params->get('vpprime_module_badge_color', '#ffffff');

if ($moduleClass) :
    $moduleAttribs['class'] .= ' ' . $moduleClass;
endif;

if ($moduleClassSuffix) :
    $moduleAttribs['class'] .= ' ' . $moduleClassSuffix;
endif;

// Only output a header class if it is not mod-row-title
if ($headerClass) :
    $headerAttribs['class'] .= ' ' . $headerClass;
endif;

// Only add aria if the moduleTag is not a div
if ($moduleTag !== 'div') {
    if ($module->showtitle) :
        $moduleAttribs['aria-labelledby'] = 'mod-' . $module->id;
        $headerAttribs['id']              = 'mod-' . $module->id;
    else :
        $moduleAttribs['aria-label'] = $module->title;
    endif;
}

$moduleAttribs = array_filter($moduleAttribs);
$headerAttribs = array_filter($headerAttribs);

$title  = '<' . $headerTag . ' ' . ArrayHelper::toString($headerAttribs) . '>' . $module->title . '</' . $headerTag . '>';
$header = '<div class="mod-header mod-block-header">';

if ($iconClass) {
    $header .= '<i class="' . $iconClass . '" aria-hidden="true"></i>';
}

$header .= $title;

if ($badgeText) {
    $header .= '<span class="mod-badge" style="--mod-badge-bg:' . $badgeBackground . ';--mod-badge-color:' . $badgeColor . ';">' . $badgeText . '</span>';
}

$header .= '</div>';

if ($subTitle) {
    $header .= '<div class="mod-subtitle">' . $subTitle . '</div>';
}

$serviceRegistry = HTMLHelper::getServiceRegistry();

if (!$serviceRegistry->hasService('vpprime_module')) {
    $serviceRegistry->register('vpprime_module', Module::class);
}

HTMLHelper::_('vpprime_module.scrollReveal', $module, $params, '[data-mod-id="' . $module->id . '"]');
?>
<<?php echo $moduleTag; ?> <?php echo ArrayHelper::toString($moduleAttribs); ?>>
    <?php if ($module->showtitle) : ?>
        <div class="mod-header-group">
            <?php echo $header; ?>
        </div>
    <?php endif; ?>
    <div class="mod-row-body">
        <?php echo $module->content; ?>
    </div>
</<?php echo $moduleTag; ?>>
