<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\Utilities\ArrayHelper;
use Virtueplanet\Plugin\System\Prime\Service\HTML\Module;

defined('_JEXEC') or die;

$module  = $displayData['module'];
$params  = $displayData['params'];
$attribs = $displayData['attribs'];

if ($module->content === null || $module->content === '') {
    return;
}

$moduleTag                    = $params->get('module_tag', 'div');
$moduleAttribs                = [];
$moduleClassSuffix            = htmlspecialchars($params->get('moduleclass_sfx', ''), ENT_QUOTES, 'UTF-8');
$moduleAttribs['class']       = $module->position . ' card';
$moduleAttribs['data-mod-id'] = $module->id;
$headerTag                    = htmlspecialchars($params->get('header_tag', 'h3'), ENT_QUOTES, 'UTF-8');
$headerClass                  = htmlspecialchars($params->get('header_class', ''), ENT_QUOTES, 'UTF-8');
$headerAttribs                = [];
$headerAttribs['class']       = 'card-title';

if ($moduleClassSuffix) :
    $moduleAttribs['class'] .= ' ' . $moduleClassSuffix;
endif;

// Only output a header class if it is not card-title
if ($headerClass && $headerClass !== 'card-title') :
    $headerAttribs['class'] = 'card-header ' . $headerClass;
endif;

// Only add aria if the moduleTag is not a div
if ($moduleTag !== 'div') {
    if ($module->showtitle) :
        $moduleAttribs['aria-labelledby'] = 'mod-' . $module->id;
        $headerAttribs['id']              = 'mod-' . $module->id;
    else :
        $moduleAttribs['aria-label'] = $module->title;
    endif;
}

$moduleAttribs = array_filter($moduleAttribs);
$headerAttribs = array_filter($headerAttribs);

$header = '<' . $headerTag . ' ' . ArrayHelper::toString($headerAttribs) . '>' . $module->title . '</' . $headerTag . '>';

$serviceRegistry = HTMLHelper::getServiceRegistry();

if (!$serviceRegistry->hasService('vpprime_module')) {
    $serviceRegistry->register('vpprime_module', Module::class);
}

HTMLHelper::_('vpprime_module.scrollReveal', $module, $params, '[data-mod-id="' . $module->id . '"]');
?>
<<?php echo $moduleTag; ?> <?php echo ArrayHelper::toString($moduleAttribs); ?>>
    <?php if ($module->showtitle && $headerClass !== 'card-title') : ?>
        <div class="mod-header-group">
            <?php echo $header; ?>
        </div>
    <?php endif; ?>
    <div class="card-body">
        <?php if ($module->showtitle && $headerClass === 'card-title') : ?>
            <?php echo $header; ?>
        <?php endif; ?>
        <?php echo $module->content; ?>
    </div>
</<?php echo $moduleTag; ?>>
