<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\Utilities\ArrayHelper;
use Virtueplanet\Plugin\System\Prime\Service\HTML\Module;

defined('_JEXEC') or die;

$module  = $displayData['module'];
$params  = $displayData['params'];
$attribs = $displayData['attribs'];

if ($module->content === null || $module->content === '') {
    return;
}

$moduleTag                    = $params->get('module_tag', 'div');
$moduleAttribs                = [];
$moduleClassSuffix            = htmlspecialchars($params->get('moduleclass_sfx', ''), ENT_QUOTES, 'UTF-8');
$moduleAttribs['class']       = 'mod-position-' . $module->position . ' mod-none';
$moduleAttribs['data-mod-id'] = $module->id;

if ($moduleClassSuffix) :
    $moduleAttribs['class'] .= ' ' . $moduleClassSuffix;
endif;

if ($moduleTag !== 'div') {
    $moduleAttribs['aria-label'] = $module->title;
}

$moduleAttribs   = array_filter($moduleAttribs);
$serviceRegistry = HTMLHelper::getServiceRegistry();

if (!$serviceRegistry->hasService('vpprime_module')) {
    $serviceRegistry->register('vpprime_module', Module::class);
}

HTMLHelper::_('vpprime_module.scrollReveal', $module, $params, '[data-mod-id="' . $module->id . '"]');
?>
<<?php echo $moduleTag; ?> <?php echo ArrayHelper::toString($moduleAttribs); ?>>
    <?php echo $module->content; ?>
</<?php echo $moduleTag; ?>>
