<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;

defined('_JEXEC') or die;

extract($displayData);

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app         = Factory::getApplication();
$template    = $app->getTemplate(true);
$params      = $template->params;
$wa          = $document->getWebAssetManager();
$sitename    = htmlspecialchars($app->get('sitename'), ENT_QUOTES, 'UTF-8');
$menuModules = ModuleHelper::getModules('offcanvas-menu');

if ($params->get('logo_file_small')) {
    $logo = '<img src="' . Uri::root(true) . '/' . htmlspecialchars($params->get('logo_file_small'), ENT_QUOTES) . '" alt="' . $sitename . '">';
} elseif ($params->get('logo_file')) {
    $logo = '<img src="' . Uri::root(true) . '/' . htmlspecialchars($params->get('logo_file'), ENT_QUOTES) . '" alt="' . $sitename . '">';
} elseif ($params->get('site_title')) {
    $logo = '<span title="' . $sitename . '">' . htmlspecialchars($params->get('site_title'), ENT_COMPAT, 'UTF-8') . '</span>';
} else {
    $logo = HTMLHelper::_('image', 'logo-small.svg', $sitename, ['class' => 'logo d-inline-block'], true, 0);
}
?>
<div class="block-offcanvas offcanvas offcanvas-start" tabindex="-1" id="<?php echo $elementId; ?>" aria-hidden="true">
    <div class="offcanvas-header">
        <div class="offcanvas-brand-logo">
            <a class="brand-logo" href="<?php echo Uri::root(true); ?>/">
                <?php echo $logo; ?>
            </a>
        </div>
        <button type="button" class="btn-icon btn-hover" data-bs-dismiss="offcanvas" aria-label="Close">
            <i class="vpi vpi-times vpi-lg" aria-hidden="true"></i>
        </button>
    </div>
    <?php if (count($menuModules) > 1) : ?>
        <?php $wa->useScript('bootstrap.tab'); // Load Bootstrap Tabs?>
        <div class="offcanvas-tabs">
            <ul class="nav nav-offcanvas-tabs" id="offcanvasMenuTab" role="tablist">
                <?php foreach ($menuModules as $key => $menuModule) : ?>
                    <?php
                    $tabId = 'offcanvas-menu-' . $menuModule->id;
                    $name  = $menuModule->showtitle ? $menuModule->title : Text::_('TPL_VP_NEOTERIC_MENU') . ' ' . ($key + 1);
                    ?>
                    <li class="nav-item" role="presentation">
                        <?php if ($key === 0) : ?>
                            <button class="nav-link active" id="<?php echo $tabId; ?>-tab" data-bs-toggle="tab" data-bs-target="#<?php echo $tabId; ?>" type="button" role="tab" aria-controls="<?php echo $tabId; ?>" aria-selected="true"><?php echo $name; ?></button>
                        <?php else : ?>
                            <button class="nav-link" id="<?php echo $tabId; ?>-tab" data-bs-toggle="tab" data-bs-target="#<?php echo $tabId; ?>" type="button" role="tab" aria-controls="<?php echo $tabId; ?>"><?php echo $name; ?></button>
                        <?php endif; ?>
                    </li>
                <?php endforeach; ?>
            </ul>
        </div>
    <?php endif; ?>
    <div class="offcanvas-body">
        <?php if (count($menuModules) > 1) : ?>
            <div class="tab-content" id="offcanvasMenuTabContent">
                <?php foreach ($menuModules as $key => $menuModule) : ?>
                    <?php $tabId = 'offcanvas-menu-' . $menuModule->id; ?>
                        <?php if ($key === 0) : ?>
                            <div class="tab-pane fade show active" id="<?php echo $tabId; ?>" role="tabpanel" aria-labelledby="<?php echo $tabId; ?>-tab">
                                <?php echo ModuleHelper::renderModule($menuModule, ['style' => 'none']); ?>
                            </div>
                        <?php else : ?>
                            <div class="tab-pane fade" id="<?php echo $tabId; ?>" role="tabpanel" aria-labelledby="<?php echo $tabId; ?>-tab">
                                <?php echo ModuleHelper::renderModule($menuModule, ['style' => 'none']); ?>
                            </div>
                        <?php endif; ?>
                <?php endforeach; ?>
            </div>
        <?php else : ?>
            <?php echo ModuleHelper::renderModule($menuModules[0], ['style' => 'none']); ?>
        <?php endif; ?>
    </div>
</div>
