<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Helper\AuthenticationHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Router\Route;
use Virtueplanet\Plugin\System\Prime\Helper\TemplateHelper;
use Virtueplanet\Plugin\System\Prime\Helper\VirtuemartHelper;

defined('_JEXEC') or die;

extract($displayData);

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app          = Factory::getApplication();
$user         = $app->getIdentity();
$template     = $app->getTemplate(true);
$params       = $template->params;
$wa           = $document->getWebAssetManager();
$lang         = Factory::getLanguage();
$formId       = 'offcanvasLoginForm';
$extraButtons = AuthenticationHelper::getLoginButtons($formId);
$returnUrl    = TemplateHelper::getReturnUrl();
$loginRedir   = (int) $params->get('login_redirect_menu', 0);
$logoutRedir  = (int) $params->get('logout_redirect_menu', 0);
$usersConfig  = ComponentHelper::getParams('com_users');

if ($user->guest && $loginRedir > 0) {
    $returnUrl = $loginRedir;
} elseif (!$user->guest && $logoutRedir > 0) {
    $returnUrl = $logoutRedir;
}

$lang->load('com_users');

$wa->useScript('core')
    ->useScript('keepalive')
    ->useScript('field.passwordview')
    ->useScript('bootstrap.collapse');

Text::script('JSHOWPASSWORD');
Text::script('JHIDEPASSWORD');
?>
<div class="offcanvas offcanvas-end" tabindex="-1" id="<?php echo $elementId; ?>" aria-hidden="true">
    <div class="offcanvas-header">
        <h5 class="offcanvas-title" id="offcanvasLoginLabel">
            <?php if ($user->guest) : ?>
                <?php echo Text::_('JLOGIN'); ?>
            <?php else : ?>
                <?php echo Text::_('TPL_VP_NEOTERIC_MY_ACCOUNT'); ?>
            <?php endif; ?>
        </h5>
        <button type="button" class="btn-icon btn-hover" data-bs-dismiss="offcanvas" aria-label="<?php echo Text::_('JLIB_HTML_BEHAVIOR_CLOSE'); ?>">
            <i class="vpi vpi-times vpi-lg" aria-hidden="true"></i>
        </button>
    </div>
    <div class="offcanvas-body px-0">
        <?php if ($user->guest) : ?>
            <form id="<?php echo $formId; ?>" action="<?php echo Route::_('index.php', true); ?>" method="post" class="px-3 pt-1 pb-3">
                <div class="control-group">
                    <div class="control-label">
                        <label for="vm-login-username" class="form-label"><?php echo Text::_('JGLOBAL_USERNAME'); ?></label>
                    </div>
                    <div class="controls">
                        <input type="text" id="vm-login-username" name="username" class="form-control" value="" autocomplete="username" spellcheck="false" />
                    </div>
                </div>
                <div class="control-group">
                    <div class="control-label">
                        <label for="vm-login-password" class="form-label"><?php echo Text::_('JGLOBAL_PASSWORD'); ?></label>
                    </div>
                    <div class="controls">
                        <div class="input-group">
                            <input id="vm-login-password" type="password" name="password" autocomplete="current-password" class="form-control" value="" />
                            <button type="button" class="btn btn-secondary input-password-toggle">
                                <span class="icon-eye icon-fw" aria-hidden="true"></span>
                                <span class="visually-hidden"><?php echo Text::_('JSHOWPASSWORD'); ?></span>
                            </button>
                        </div>
                    </div>
                </div>
                <?php if (PluginHelper::isEnabled('system', 'remember')) : ?>
                    <div class="control-group">
                        <div class="controls">
                            <div class="form-check">
                                <input type="checkbox" name="remember" class="form-check-input" value="yes" id="vm-login-remember" />
                                <label class="form-check-label" for="vm-login-remember">
                                    <?php echo Text::_('COM_USERS_LOGIN_REMEMBER_ME'); ?>
                                </label>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                <?php foreach ($extraButtons as $button) :
                    $dataAttributeKeys = array_filter(array_keys($button), function ($key) {
                        return substr($key, 0, 5) == 'data-';
                    });
                    ?>
                    <div class="control-group">
                        <button type="button" class="btn btn-secondary w-100 <?php echo $button['class'] ?? '' ?>" <?php foreach ($dataAttributeKeys as $key) :
                            ?> <?php echo $key ?>="<?php echo $button[$key] ?>" <?php
                                                                             endforeach; ?> <?php if ($button['onclick']) :
    ?> onclick="<?php echo $button['onclick'] ?>" <?php
                                                                             endif; ?> title="<?php echo Text::_($button['label']) ?>" id="<?php echo $button['id'] ?>">
                            <?php if (!empty($button['icon'])) : ?>
                                <span class="<?php echo $button['icon'] ?>"></span>
                            <?php elseif (!empty($button['image'])) : ?>
                                <?php echo $button['image']; ?>
                            <?php elseif (!empty($button['svg'])) : ?>
                                <?php echo $button['svg']; ?>
                            <?php endif; ?>
                            <?php echo Text::_($button['label']) ?>
                        </button>
                    </div>
                <?php endforeach; ?>
                <div class="control-group">
                    <button type="submit" name="Submit" class="btn btn-primary w-100"><?php echo Text::_('JLOGIN'); ?></button>
                </div>
                <div class="control-group text-center mb-0">
                    <ul class="list-inline">
                        <li class="list-inline-item">
                            <a href="<?php echo Route::_('index.php?option=com_users&view=remind'); ?>" rel="nofollow">
                                <?php echo Text::_('COM_USERS_LOGIN_REMIND'); ?>
                            </a>
                        </li>
                        <li class="list-inline-item">
                            <a href="<?php echo Route::_('index.php?option=com_users&view=reset'); ?>" rel="nofollow">
                                <?php echo Text::_('COM_USERS_LOGIN_RESET'); ?>
                            </a>
                        </li>
                    </ul>
                </div>
                <input type="hidden" name="task" value="user.login" />
                <input type="hidden" name="option" value="com_users" />
                <input type="hidden" name="return" value="<?php echo base64_encode($returnUrl); ?>" />
                <?php echo HTMLHelper::_('form.token'); ?>
            </form>
            <?php if ($usersConfig->get('allowUserRegistration')) : ?>
                <div class="separator-line separator-line-offcanvas mb-5" aria-hidden="true" tabindex="-1"></div>
                <div class="offcanvas-registration px-3 mb-5 d-flex flex-column justify-content-center align-items-center text-center">
                    <i class="far fa-user" aria-hidden="true" tabindex="-1"></i>
                    <p class="fw-bold">
                        <?php echo Text::_('TPL_VP_NEOTERIC_NO_ACCOUNT_QUESTION'); ?>
                    </p>
                    <a href="<?php echo Route::_('index.php?option=com_users&view=registration'); ?>" class="btn btn-link">
                        <?php echo Text::_('TPL_VP_NEOTERIC_REGISTER'); ?>
                    </a>
                </div>
                <div class="separator-line separator-line-offcanvas" aria-hidden="true" tabindex="-1"></div>
            <?php endif; ?>
        <?php else : ?>
            <form id="<?php echo $formId; ?>" action="<?php echo Route::_('index.php', true); ?>" method="post" class="px-3 pt-1 pb-3">
                <div class="offcanvas-logout d-flex flex-column justify-content-center align-items-center text-center">
                    <i class="far fa-user" aria-hidden="true" tabindex="-1"></i>
                    <p class="fw-bold">
                        <?php echo Text::sprintf('TPL_VP_NEOTERIC_LOGIN_HINAME', htmlspecialchars($user->username, ENT_COMPAT, 'UTF-8')); ?>
                    </p>
                    <div class="mb-3">
                        <?php if (VirtuemartHelper::isInstalled()) : ?>
                            <a href="<?php echo Route::_('index.php?option=com_virtuemart&view=user'); ?>" class="btn btn-link">
                                <?php echo Text::_('COM_VIRTUEMART_YOUR_ACCOUNT_DETAILS'); ?>
                            </a>
                        <?php else : ?>
                            <a href="<?php echo Route::_('index.php?option=com_users&view=profile'); ?>" class="btn btn-link">
                                <?php echo Text::_('COM_USERS_PROFILE'); ?>
                            </a>
                        <?php endif; ?>
                    </div>
                    <?php if (VirtuemartHelper::isInstalled()) : ?>
                        <div class="mb-3">
                            <a href="<?php echo Route::_('index.php?option=com_virtuemart&view=orders'); ?>" class="btn btn-link">
                                <?php echo Text::_('COM_VIRTUEMART_YOUR_ORDERS'); ?>
                            </a>
                        </div>
                    <?php endif; ?>
                    <button type="submit" name="Submit" class="btn btn-primary w-100 mt-5"><?php echo Text::_('JLOGOUT'); ?></button>
                    <input type="hidden" name="option" value="com_users">
                    <input type="hidden" name="task" value="user.logout">
                    <input type="hidden" name="return" value="<?php echo base64_encode($returnUrl); ?>">
                    <?php echo HTMLHelper::_('form.token'); ?>
                </div>
            </form>
        <?php endif; ?>
    </div>
</div>
