<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Language\Text;
use Virtueplanet\Plugin\System\Prime\Helper\ContentHelper;

defined('_JEXEC') or die;

extract($displayData);

/**
 * @var   string   $position          The position of the cookie consent
 * @var   integer  $policyArticleId   The link to the cookie policy
 * @var   integer  $tenure            Consent tenure in days
 */

$policyLink = '';
$positions  = ['top-left', 'top', 'top-right', 'center', 'bottom-left', 'bottom', 'bottom-right'];

if (empty($position) || !in_array($position, $positions)) {
    $position = 'bottom-right';
}

if (!empty($policyArticleId)) {
    $policyLink = ContentHelper::getArticleUrl($policyArticleId);
}
?>
<!--googleoff: all-->
<div id="VPCookieConsent" class="vp-cookie-consent <?php echo $position; ?> vp-hide vp-fade" role="dialog" tabindex="-1" aria-hidden="true" aria-label="<?php echo Text::_('TPL_VP_NEOTERIC_COOKIE_CONSENT_LABEL'); ?>" aria-describedby="CookieConsentDesc" data-tenure="<?php echo $tenure; ?>">
    <div class="vp-cookie-consent-inner">
        <div id="CookieConsentDesc" class="vp-cookie-consent-message">
            <?php echo Text::_('TPL_VP_NEOTERIC_COOKIE_CONSENT_DESC'); ?>
            <?php if (!empty($policyLink)) : ?>
                &nbsp;<a href="<?php echo $policyLink; ?>" class="vp-cookie-consent-link"><?php echo Text::_('TPL_VP_NEOTERIC_COOKIE_CONSENT_POLICY_LINK_LABEL'); ?></a>
            <?php endif; ?>
        </div>
        <button type="button" class="btn btn-primary vp-cookie-consent-button" data-btn="cookieconsent">
            <?php echo Text::_('TPL_VP_NEOTERIC_COOKIE_CONSENT_POLICY_ACCEPT_BTN_LABEL'); ?>
        </button>
    </div>
</div>
<!--googleon: all-->