<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

defined('_JEXEC') or die;

vmJsApi::jPrice();
vmJsApi::cssSite();

$pageUrl      = VMEssentialsHelperRoute::getRoute('wishlist');
$pageUrl      = Route::_($pageUrl, false);
$return       = VMEssentialsHelperUtility::encode($pageUrl);
$wishlistUser = $this->state->get('wishlist.user', null);
$ratingModel  = VmModel::getModel('ratings');
$showRating   = $ratingModel->showRating();
?>
<div class="vmessentials-wrapper vme-wishlist">
    <?php if ($this->params->get('show_page_heading')) : ?>
        <div class="page-header">
            <h1 class="page-header">
                <?php echo $this->escape($this->params->get('page_heading')); ?>
            </h1>
            <?php if ($wishlistUser) : ?>
                <h5>
                    <?php echo Text::sprintf('COM_VMESSENTIALS_WISHLIST_HEADING', $wishlistUser->get('name')); ?>
                </h5>
            <?php endif; ?>
        </div>
    <?php endif; ?>
    <?php if (empty($this->items)) : ?>
        <div class="empty-card">
            <div class="empty-card-icon" aria-hidden="true" tabindex="-1">
                <i class="fas fa-heart"></i>
            </div>
            <div class="empty-card-heading">
                <?php echo Text::_('COM_VMESSENTIALS_EMPTY_WISHLIST'); ?>
            </div>
        </div>
    <?php else : ?>
        <?php if (!$this->state->get('id')) : ?>
            <div class="vme-share-container vme-popover-wrapper mb-4">
                <button type="button" class="btn btn-secondary" data-vmepopover="true">
                    <?php echo Text::_('COM_VMESSENTIALS_SHARE'); ?><span class="vme-dropdown-caret" aria-hidden="true"></span>
                </button>
                <div class="vme-popover">
                    <div class="vme-share-inner">
                        <?php if (!$this->permalink) : ?>
                            <p><?php echo Text::_('COM_VMESSENTIALS_MSG_WISHLIST_NEED_LOGIN_SHARE'); ?></p>
                            <a href="<?php echo Route::_('index.php?option=com_users&view=login&return=' . $return); ?>" class="btn btn-secondary"><?php echo Text::_('JLOGIN'); ?></a>
                        <?php else : ?>
                            <div class="vme-share-title"><?php echo Text::_('COM_VMESSENTIALS_PERMALINK'); ?></div>
                            <div class="vme-input-section">
                                <div class="vme-input-group">
                                    <input type="text" class="vme-form-control" value="<?php echo Route::_($this->permalink, true, 0, true); ?>" aria-label="<?php echo Route::_($this->permalink, true, 0, true); ?>" data-vmecopyfield="true" readonly />
                                    <div class="vme-input-group-btn">
                                        <button type="button" class="btn-vme" data-vmecopy="true" data-vmedonetext="<?php echo $this->escape(Text::_('COM_VMESSENTIALS_COPIED')); ?>">
                                            <?php echo Text::_('COM_VMESSENTIALS_COPY'); ?>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    
        <?php if ($this->params->get('show_pagination_limit', 0)) : ?>
            <form action="<?php echo htmlspecialchars(Uri::getInstance()->toString()); ?>" method="post" class="form-inline clearfix">
                <div class="d-flex justify-content-end mb-4">
                    <label for="limit"><?php echo Text::_('JGLOBAL_DISPLAY_NUM'); ?></label>
                    <?php echo $this->pagination->getLimitBox(); ?>
                </div>
                <input type="hidden" name="limitstart" value="" />
                <input type="hidden" name="task" value="" />
            </form>
        <?php endif; ?>

        <?php echo shopFunctionsF::renderVmSubLayout('products', ['products' => [$this->items], 'currency' => $this->currency, 'showRating' => $showRating, 'products_per_row' => VmConfig::get('products_per_row', 3),'isWishlist' => true, 'removeFromWishlist' => !$this->state->get('id')]); ?>

        <?php if ($this->pagination->pagesTotal > 1) : ?>
            <div class="pagination-container">
                <p class="counter pull-right">
                    <?php echo $this->pagination->getPagesCounter(); ?>
                </p>
                <?php echo $this->pagination->getPagesLinks(); ?>
            </div>
        <?php endif; ?>
    <?php endif; ?>
</div>

<?php echo vmJsApi::writeJS(); ?>
