<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Virtueplanet\Plugin\System\Prime\Helper\VirtuemartHelper;

defined('_JEXEC') or die;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app        = Factory::getApplication();
$model      = VmModel::getModel('manufacturer');
$template   = $app->getTemplate(true);
$params     = $template->params;
$lazyLoad   = $params->get('vm_image_lazyload', 1) && !$app->input->getInt('print', 0);
$imageClass = $lazyLoad ? 'manufacturer-image lazy' : 'manufacturer-image';
$document   = $app->getDocument();
$wa         = $document->getWebAssetManager();
?>
<div class="product-manufacturers ms-auto ps-3 d-flex flex-column">
    <?php foreach ($this->product->virtuemart_manufacturer_id as $manufacturerId) : ?>
        <?php
        $manufacturer = $model->getManufacturer($manufacturerId);
        $model->addImages($manufacturer, 1);
        $thumbnail = VirtuemartHelper::prepareLazyImageHTML($manufacturer->images[0]->displayMediaThumb(['class' => $imageClass], false), $lazyLoad, 10, 10, '#fff');

        if (strpos($thumbnail, (string) VmConfig::get('no_image_found')) !== false || strpos($thumbnail, (string) VmConfig::get('no_image_set')) !== false) {
            $thumbnail = $manufacturer->mf_name;
        }

        $url        = Route::_('index.php?option=com_virtuemart&view=manufacturer&virtuemart_manufacturer_id=' . $manufacturerId);
        $buttonText = $manufacturer->mf_name;

        if ($params->get('manufacturer_link_to', 'products') === 'products') {
            $url         = Route::_('index.php?option=com_virtuemart&view=category&virtuemart_category_id=0&virtuemart_manufacturer_id=' . $manufacturerId);
            $buttonText  = vmText::sprintf('COM_VIRTUEMART_PRODUCT_FROM_MF', $manufacturer->mf_name);
        }
        ?>
        <div class="product-manufacturer">
            <a href="<?php echo $url; ?>" class="manufacturer-modal-link" target="_parent"><?php echo $thumbnail; ?></a>
        </div>
    <?php endforeach; ?>
</div>