<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Virtueplanet\Plugin\System\Prime\Helper\VirtuemartHelper;

defined('_JEXEC') or die;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app           = Factory::getApplication();
$template      = $app->getTemplate(true);
$params        = $template->params;
$document      = $app->getDocument();
$wa            = $document->getWebAssetManager();
$width         = VmConfig::get('img_width_full', 0);
$height        = VmConfig::get('img_height_full', 0);
$lazyLoad      = $params->get('vm_image_lazyload', 1) && !$app->input->getInt('print', 0);
$imageClass    = $lazyLoad ? 'product-image tns-lazy-img' : 'product-image';
$imageClassStd = $lazyLoad ? 'product-image lazy' : 'product-image';

$script = "
(function() {
    var productImageGallery = window.productImageGallery || {};
    
    productImageGallery.mainGalleryDefaultOptions = {
        container: '.product-image-gallery__main-multiple',
        controlsContainer:  '.product-image-gallery__main-controls',
        nav: false,
        center: true,
        items: 1,
        autoHeight: false,
        mouseDrag: false,
        autoplay: false,
        speed: 400,
        loop: false,
        slideBy: 1,
        lazyload: " . ($lazyLoad ? 'true' : 'false') . ",
        992: {
            mouseDrag: true,
            swipeAngle: false
        }
    };

    productImageGallery.tnsMainGallery = null;
    productImageGallery.mainImageMaxHeight = 0;

    productImageGallery.destroyAllTnsGallery = function() {
        if (productImageGallery.tnsMainGallery) {
            productImageGallery.tnsMainGallery.destroy();
        }

        productImageGallery.mainImageMaxHeight = 0;
    }

    productImageGallery.initMainGallery = function() {
        productImageGallery.tnsMainGallery = tns(productImageGallery.mainGalleryDefaultOptions);

        var info = productImageGallery.tnsMainGallery.getInfo();

        if (productImageGallery.mainGalleryDefaultOptions.lazyload) {
            [].slice.call(info.container.querySelectorAll('img')).forEach(function (img) {
                img.removeEventListener('load', window.parent.GLightboxHelper.setContainerHeight);
                img.addEventListener('load', window.parent.GLightboxHelper.setContainerHeight);
                // img.removeEventListener('load', productImageGallery.onMainImageLoad);
                // img.addEventListener('load', productImageGallery.onMainImageLoad);
            });
        }
    }

    productImageGallery.onMainImageLoad = function(event) {
        var info = productImageGallery.tnsMainGallery.getInfo();

        if (event.target && event.target.tagName == 'IMG' && event.target.height > productImageGallery.mainImageMaxHeight) {
            [].slice.call(info.container.querySelectorAll('.product-image-gallery__item-inner')).forEach(function (element) {
                element.style.setProperty('--template-product-main-image-min-height', event.target.height + 'px');
            });

            productImageGallery.mainImageMaxHeight = event.target.height;
        }
    }

    productImageGallery.isWithMultipleImages = function() {
        if (document.querySelector(productImageGallery.mainGalleryDefaultOptions.container)) {
            return true;
        }

        return false;
    }
    
    document.addEventListener('DOMContentLoaded', function () {
        if (productImageGallery.isWithMultipleImages()) {
            productImageGallery.initMainGallery();
        }
        
        if (typeof jQuery !== typeof undefined) {
            jQuery('body').on('updateVirtueMartProductDetail', function () {
                if (productImageGallery.isWithMultipleImages()) {
                    productImageGallery.destroyAllTnsGallery();
                    productImageGallery.initMainGallery();
                }
            });
        }
    });
})();
";

$wa->usePreset('tiny-slider');

vmJsApi::addJScript('product-image-gallery', $script);
?>
<div class="product-image-gallery">
    <?php if (count($this->product->images) > 1) : ?>
        <div class="product-image-gallery__main-wrapper">
            <figure class="product-image-gallery__main product-image-gallery__main-multiple is-tns-gallery">
                <?php foreach ($this->product->images as $image) : ?>
                    <?php if (!empty($image) && is_object($image)) : ?>
                        <div class="product-image-gallery__item">
                            <div class="product-image-gallery__item-inner">
                                <?php if (!empty($width) || !empty($height)) : ?>
                                    <?php echo VirtuemartHelper::prepareLazyImageHTML($image->displayMediaThumb(['class' => $imageClass], false, '', true, false, false, $width, $height), $lazyLoad); ?>
                                <?php else : ?>
                                    <?php echo VirtuemartHelper::prepareLazyImageHTML($image->displayMediaFull(['class' => $imageClass], false, '', false), $lazyLoad); ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endforeach; ?>
            </figure>
            <div class="product-image-gallery__main-controls">
                <button type="button" class="btn btn-nobg">
                    <i class="fas fa-chevron-left" aria-hidden="true"></i>
                    <span class="visually-hidden">Prev</span>
                </button>
                <button type="button" class="btn btn-nobg">
                    <i class="fas fa-chevron-right" aria-hidden="true"></i>
                    <span class="visually-hidden">Next</span>
                </button>
            </div>
        </div>
    <?php else : ?>
        <div class="product-image-gallery__main-wrapper">
            <figure class="product-image-gallery__main product-image-gallery__main-single">
                <div class="product-image-gallery__item-inner">
                    <?php $image = reset($this->product->images); ?>
                    <?php if (!empty($width) || !empty($height)) : ?>
                        <?php echo VirtuemartHelper::prepareLazyImageHTML($image->displayMediaThumb(['class' => $imageClassStd], false, '', true, false, false, $width, $height), $lazyLoad); ?>
                    <?php else : ?>
                        <?php echo VirtuemartHelper::prepareLazyImageHTML($image->displayMediaFull(['class' => $imageClassStd], false, '', false), $lazyLoad); ?>
                    <?php endif; ?>
                </div>
            </figure>
        </div>
    <?php endif; ?>
</div>