<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;

defined('_JEXEC') or die;

vmJsApi::jPrice();
vmJsApi::cssSite();

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app        = Factory::getApplication();
$template   = $app->getTemplate(true);
$params     = $template->params;
$productUrl = Route::_('index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id=' . $this->product->virtuemart_product_id .
                         '&virtuemart_category_id=' . $this->product->virtuemart_category_id);
?>
<div class="productdetails-view vm-productdetails" data-vm="product-container">
    <div class="quickview-body d-flex flex-wrap">
        <div class="col-12 col-md-6">
            <div class="product-images-section">
                <?php echo $this->loadTemplate('imagegallery'); ?>
                <?php if (VmConfig::get('product_navigation', 1)) : ?>
                    <div class="quickview-product-navigation d-flex">
                        <?php if (!empty($this->product->neighbours['previous'][0])) : ?>
                            <?php
                            $prev_link         = Route::_('index.php?option=com_vmessentials&view=quickview&tmpl=component&virtuemart_product_id=' . $this->product->neighbours['previous'][0]['virtuemart_product_id']);
                            $prev_product_name = $this->product->neighbours ['previous'][0]['product_name'];
                            ?>
                            <a href="<?php echo $prev_link; ?>" class="page-nav-link" title="<?php echo $prev_product_name; ?>" rel="nofollow">
                                <i class="fas fa-chevron-left" aria-hidden="true"></i><span class="sr-only"><?php echo $prev_product_name; ?></span>
                            </a>
                        <?php endif; ?>
                        <a href="<?php echo $productUrl; ?>" class="flex-fill" target="_parent"><?php echo vmText::_('COM_VIRTUEMART_PRODUCT_DETAILS'); ?></a>
                        <?php if (!empty($this->product->neighbours['next'][0])) : ?>
                            <?php
                            $next_link         = Route::_('index.php?option=com_vmessentials&view=quickview&tmpl=component&virtuemart_product_id=' . $this->product->neighbours['next'][0]['virtuemart_product_id']);
                            $next_product_name = $this->product->neighbours ['next'][0]['product_name'];
                            ?>
                            <a href="<?php echo $next_link; ?>" class="page-nav-link" title="<?php echo $next_product_name; ?>" rel="nofollow">
                                <i class="fas fa-chevron-right" aria-hidden="true"></i><span class="sr-only"><?php echo $next_product_name; ?></span>
                            </a>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="col-12 col-md-6">
            <div class="quickview-content">
                <div class="quickview-content-inner">
                    <div class="product-title-container <?php echo $this->showRating && !empty($this->product->rating) ? 'mb-2' : 'mb-3'; ?>">
                        <h1 class="product-title mt-0 mb-0">
                            <a href="<?php echo $productUrl ?>" target="_parent"><?php echo $this->product->product_name; ?></a>
                        </h1>
                    </div>
                    <?php if (!empty($this->product->event->afterDisplayTitle)) : ?>
                        <div class="event-afterDisplayTitle">
                            <?php echo $this->product->event->afterDisplayTitle ?>
                        </div>
                    <?php endif; ?>
                    <?php if ($this->showRating && !empty($this->product->rating)) : ?>
                        <div class="product-rating mb-3">
                            <?php echo shopFunctionsF::renderVmSubLayout('rating', ['showRating' => $this->showRating, 'product' => $this->product, 'readonly' => true, 'showCount' => true, 'showReviews' => false]); ?>
                        </div>
                    <?php endif; ?>
                    <div class="product-overview-container d-flex mb-3">
                        <div class="product-prices-stock flex-fill">
                            <div class="product-prices-wrapper mb-3">
                                <?php echo shopFunctionsF::renderVmSubLayout('prices', ['product' => $this->product, 'currency' => $this->currency, 'showDetails' => false]); ?>
                            </div>
                            <div class="product-stock">
                                <?php if (VmConfig::get('display_stock', 1)) : ?>
                                    <?php echo shopFunctionsF::renderVmSubLayout('stock', ['product' => $this->product]); ?>
                                <?php endif; ?>
                                <?php echo shopFunctionsF::renderVmSubLayout('stockhandle', ['product' => $this->product]); ?>
                            </div>
                        </div>
                        <?php if (VmConfig::get('show_manufacturers', 1)) : ?>
                            <?php echo $this->loadTemplate('manufacturer'); ?>
                        <?php endif; ?>
                    </div>
                    <?php if (!empty($this->product->product_s_desc)) : ?>
                        <?php if ($this->product->product_s_desc != strip_tags($this->product->product_s_desc)) : ?>
                            <div class="product-short-description mb-3">
                                <?php echo $this->product->product_s_desc; ?>
                            </div>
                        <?php else : ?>
                            <p class="product-short-description mb-3">
                                <?php echo nl2br($this->product->product_s_desc); ?>
                            </p>
                        <?php endif; ?>
                    <?php endif; ?>
                    <?php if (!empty($this->product->customfieldsSorted['ontop'])) : ?>
                        <div class="ontop-fields-container mb-3">
                            <?php echo shopFunctionsF::renderVmSubLayout('customfields', ['product' => $this->product, 'position' => 'ontop']); ?>
                        </div>
                    <?php endif; ?>
                    <div class="add-to-cart-container mb-3">
                        <?php echo shopFunctionsF::renderVmSubLayout('addtocart', ['product' => $this->product]); ?>
                    </div>
                    <div class="separator-line mb-3" aria-hidden="true" tabindex="-1"></div>
                    <?php if ($params->get('show_sku', 1) && !empty($this->product->product_sku)) : ?>
                        <div class="product-sku mb-2">
                            <span><?php echo vmText::_('COM_VIRTUEMART_CART_SKU'); ?>:</span>&nbsp;<span class="text-muted"><?php echo $this->product->product_sku; ?></span>
                        </div>
                    <?php endif; ?>
                    <?php if ($params->get('show_mpn', 0) && !empty($this->product->product_mpn)) : ?>
                        <div class="product-mpn mb-2">
                            <span><?php echo vmText::_('COM_VIRTUEMART_PRODUCT_MPN'); ?>:</span>&nbsp;<span class="text-muted"><?php echo $this->product->product_mpn; ?></span>
                        </div>
                    <?php endif; ?>
                    <?php if ($params->get('show_gtin', 1) && !empty($this->product->product_gtin)) : ?>
                        <div class="product-gtin mb-2">
                            <span><?php echo vmText::_('COM_VIRTUEMART_PRODUCT_GTIN'); ?>:</span>&nbsp;<span class="text-muted"><?php echo $this->product->product_gtin; ?></span>
                        </div>
                    <?php endif; ?>
                    <?php if (!empty($this->product->product_box)) : ?>
                        <div class="product-box mb-2">
                            <span><?php echo vmText::_('COM_VIRTUEMART_PRODUCT_UNITS_IN_BOX'); ?></span><span class="text-muted"><?php echo $this->product->product_box; ?></span>
                        </div>
                    <?php endif; ?>
                    <?php if (!empty($this->product->virtuemart_category_id)) : ?>
                        <div class="mb-2">
                            <span><?php echo vmText::_('COM_VIRTUEMART_CATEGORY_NAME'); ?>:</span>&nbsp;<a href="<?php echo Route::_('index.php?option=com_virtuemart&view=category&virtuemart_category_id=' . $this->product->virtuemart_category_id); ?>" class="link-body-invert" target="_parent"><?php echo vmText::_($this->product->category_name); ?></a>
                        </div>
                    <?php endif; ?>
                    <?php if ($params->get('show_social_share', 1)) : ?>
                        <div class="social-share-icons">
                            <?php echo shopFunctionsF::renderVmSubLayout('productshare', ['product' => $this->product]); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php echo vmJsApi::writeJS(); ?>
<script type="text/javascript">
    document.addEventListener('DOMContentLoaded', function() {
        [].slice.call(document.querySelectorAll('a.page-nav-link')).forEach(function (element) {
            element.removeEventListener('click', parent.window.GLightboxHelper.showIframeLoader);
            element.addEventListener('click', parent.window.GLightboxHelper.showIframeLoader);
        });
    });

    Virtuemart.container = jQuery('.productdetails-view');
    Virtuemart.containerSelector = '.productdetails-view';
</script>
