<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

defined('_JEXEC') or die;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app         = Factory::getApplication();
$document    = $app->getDocument();
$wa          = $document->getWebAssetManager();
$ratingModel = VmModel::getModel('ratings');
$showRating  = $ratingModel->showRating();

vmJsApi::jPrice();
vmJsApi::cssSite();

if (!empty($this->items)) {
    $count          = count($this->items);
    $availableWidth = 80;

    $css  = '.vme-compare-title{width:20%;}';
    $css .= '.vme-compare-data{width:' . ceil($availableWidth / $count) . '%;max-width:40%;}';

    $wa->addInlineStyle($css);
}
?>
<div class="vmessentials-wrapper">
    <?php if ($this->params->get('show_page_heading')) : ?>
        <div class="page-header">
            <h1><?php echo $this->escape($this->params->get('page_heading')); ?></h1>
        </div>
    <?php endif; ?>
    <?php if (empty($this->items)) : ?>
        <div class="empty-card">
            <div class="empty-card-icon" aria-hidden="true" tabindex="-1">
                <i class="fas fa-random"></i>
            </div>
            <div class="empty-card-heading">
                <?php echo Text::_('COM_VMESSENTIALS_EMPTY_COMPARE'); ?>
            </div>
        </div>
    <?php else : ?>
        <div class="vme-share-container vme-popover-wrapper">
            <button type="button" class="btn btn-secondary" data-vmepopover="true">
                <?php echo Text::_('COM_VMESSENTIALS_SHARE'); ?><span class="vme-dropdown-caret" aria-hidden="true"></span>
            </button>
            <div class="vme-popover">
                <div class="vme-share-inner">
                    <div class="vme-share-title"><?php echo Text::_('COM_VMESSENTIALS_PERMALINK'); ?></div>
                    <div class="vme-input-section">
                        <div class="vme-input-group">
                            <input type="text" class="vme-form-control" value="<?php echo Route::_($this->permalink, true, 0, true); ?>" aria-label="<?php echo Route::_($this->permalink, true, 0, true); ?>" data-vmecopyfield="true" readonly />
                            <div class="vme-input-group-btn">
                                <button type="button" class="btn-vme" data-vmecopy="true" data-vmedonetext="<?php echo $this->escape(Text::_('COM_VMESSENTIALS_COPIED')); ?>">
                                    <?php echo Text::_('COM_VMESSENTIALS_COPY'); ?>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="vme-table-container">
            <table class="vme-table">
                <?php foreach ($this->variables as $var) : ?>
                    <?php if ($var == 'custom_fields' && $this->show($var) && !empty($this->fields)) : ?>
                        <?php foreach ($this->fields as $id => $name) : ?>
                            <tr class="<?php echo 'vmevar_' . $var; ?> customfield-<?php echo $id ?>">
                                <th class="vme-compare-title"><?php echo $name; ?></th>
                                <?php foreach ($this->items as $product) : ?>
                                    <td>
                                        <?php if (!empty($product->customfieldsGrouped[$id])) {
                                            foreach ($product->customfieldsGrouped[$id] as $i => $field) {
                                                echo $field->display;
                                                echo '<div class="vme-separator" aria-hidden="true"></div>';
                                            }
                                        } ?>
                                    </td>
                                <?php endforeach; ?>
                            </tr>
                        <?php endforeach; ?>
                    <?php elseif ($this->show($var)) : ?>
                        <tr class="<?php echo 'vmevar_' . $var; ?>">
                            <th class="vme-compare-title"><?php echo $this->getTitle($var) ?></th>
                            <?php foreach ($this->items as $product) : ?>
                                <td class="vme-compare-data">
                                    <?php if ($var == 'product_name') : ?>
                                        <h3 class="product-name"><?php echo HTMLHelper::link(Route::_($product->link), $product->product_name); ?></h3>
                                        <?php if (!$this->state->get('has_id')) : ?>
                                            <form action="<?php echo Route::_('index.php?option=com_vmessentials&view=compare') ?>" method="post" class="vmessentials-form">
                                                <button type="submit" class="vme-compare-remove btn-vme-round" title="<?php echo Text::_('COM_VMESSENTIALS_REMOVE_ITEM') ?>">
                                                    <i class="fa fa-times" aria-hidden="true"></i>
                                                </button>
                                                <input type="hidden" name="option" value="com_vmessentials" />
                                                <input type="hidden" name="task" value="compare.remove" />
                                                <input type="hidden" name="virtuemart_product_id" value="<?php echo (int) $product->virtuemart_product_id; ?>" />
                                                <input type="hidden" name="product_name" value="<?php echo htmlspecialchars($product->product_name, ENT_COMPAT, 'UTF-8'); ?>" />
                                                <?php echo HTMLHelper::_('form.token'); ?>
                                                <?php echo HTMLHelper::_('vmessentials.returnUri'); ?>
                                            </form>
                                        <?php endif; ?>
                                    <?php elseif ($var == 'product_category' && !empty($product->virtuemart_category_id)) : ?>
                                        <a href="<?php echo Route::_('index.php?option=com_virtuemart&view=category&virtuemart_category_id=' . $product->virtuemart_category_id) ?>" target="_blank">
                                            <?php echo $product->category_name; ?></a>
                                    <?php elseif ($var == 'mf_name' && !empty($product->virtuemart_manufacturer_id[0])) : ?>
                                        <a href="<?php echo Route::_('index.php?option=com_virtuemart&view=category&virtuemart_category_id=0&virtuemart_manufacturer_id=' . $product->virtuemart_manufacturer_id[0]) ?>" target="_blank">
                                            <?php echo $product->mf_name; ?></a>
                                    <?php elseif ($var == 'rating') : ?>
                                        <?php echo shopFunctionsF::renderVmSubLayout('rating', ['showRating' => $showRating, 'product' => $product, 'readonly' => true]); ?>
                                    <?php elseif ($var == 'image' && !empty($product->images[0])) : ?>
                                        <a href="<?php echo Route::_($product->link); ?>"><?php echo $product->images[0]->displayMediaThumb('class="vme-image"', false); ?></a>
                                        <div class="vme-compare-buttons">
                                            <ul class="vme-list-inline">
                                                <li><?php echo HTMLHelper::_('vmessentials.addtowishlist', $product, false); ?></li>
                                                <li><?php echo HTMLHelper::_('vmessentials.quickview', $product, false); ?></li>
                                            </ul>
                                        </div>
                                    <?php elseif ($var == 'product_sku') : ?>
                                        <?php echo $product->product_sku; ?>
                                    <?php elseif ($var == 'price') : ?>
                                        <?php echo shopFunctionsF::renderVmSubLayout('prices', array('product' => $product, 'currency' => $this->currency)); ?>
                                    <?php elseif ($var == 'product_s_desc') : ?>
                                        <?php echo $product->product_s_desc; ?>
                                    <?php elseif ($var == 'product_desc') : ?>
                                        <?php echo $product->product_desc; ?>
                                    <?php elseif ($var == 'product_length' && !empty($product->product_length)) : ?>
                                        <?php echo (float) $product->product_length . ' ' . $product->product_lwh_uom; ?>
                                    <?php elseif ($var == 'product_width' && !empty($product->product_width)) : ?>
                                        <?php echo (float) $product->product_width . ' ' . $product->product_lwh_uom; ?>
                                    <?php elseif ($var == 'product_height' && !empty($product->product_height)) : ?>
                                        <?php echo (float) $product->product_height . ' ' . $product->product_lwh_uom; ?>
                                    <?php elseif ($var == 'product_weight' && !empty($product->product_weight)) : ?>
                                        <?php echo (float) $product->product_weight . ' ' . $product->product_weight_uom; ?>
                                    <?php elseif ($var == 'product_packaging' && !empty($product->product_packaging)) : ?>
                                        <?php echo (float) $product->product_packaging . ' ' . $product->product_unit; ?>
                                    <?php elseif ($var == 'product_box' && !empty($product->product_box)) : ?>
                                        <?php echo $product->product_box; ?>
                                    <?php elseif ($var == 'product_availability') : ?>
                                        <?php echo shopFunctionsF::renderVmSubLayout('stockhandle', array('product' => $product)) ?>
                                    <?php elseif ($var == 'product_stock') : ?>
                                        <?php echo $product->stock->stock_tip; ?>
                                    <?php elseif ($var == 'add_to_cart') : ?>
                                        <div class="product-container" data-vm="product-container">
                                            <?php echo shopFunctionsF::renderVmSubLayout('addtocart', array('product' => $product, 'isList' => false)); ?>
                                        </div>
                                    <?php endif; ?>
                                </td>
                            <?php endforeach; ?>
                        </tr>
                    <?php endif; ?>
                <?php endforeach; ?>
            </table>
        </div>
    <?php endif; ?>
</div>
<?php echo vmJsApi::writeJS(); ?>
