<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Uri\Uri;

defined('_JEXEC') or die;
?>
<div class="virtuemart-view">
    <?php if (vmAccess::isFEmanager('product.add')) : ?>
        <div class="d-flex justify-content-end mb-4">
            <a href="<?php echo Uri::root() . 'index.php?option=com_virtuemart&tmpl=component&view=product&task=edit&virtuemart_product_id=0&managing=1'; ?>" class="btn btn-success"><?php echo vmText::_('COM_VIRTUEMART_PRODUCT_FORM_NEW_PRODUCT'); ?></a>
        </div>
    <?php endif; ?>

    <?php if (!empty($this->vendor->vendor_store_desc) && VmConfig::get('show_store_desc', 1)) : ?>
        <div class="vendor-store-desc mb-4">
            <?php echo $this->vendor->vendor_store_desc; ?>
        </div>
    <?php endif; ?>

    <?php if ($this->categories && VmConfig::get('show_categories', 1)) : ?>
        <?php echo shopFunctionsF::renderVmSubLayout('categories', ['categories' => $this->categories, 'categories_per_row' => VmConfig::get('categories_per_row', 3)]); ?>
    <?php endif; ?>

    <?php if (!empty($this->products)) : ?>
        <?php echo shopFunctionsF::renderVmSubLayout($this->productsLayout, ['products' => $this->products, 'currency' => $this->currency, 'products_per_row' => VmConfig::get('homepage_products_per_row', 3), 'showRating' => $this->showRating]); ?>
    <?php endif; ?>
</div>
