<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
**/

defined('_JEXEC') or die;

$vendorFieldSkips = property_exists($this, 'vendorFieldSkips') ? $this->vendorFieldSkips : [];
?>
<div class="vendor-details-view">
    <div class="page-header">
        <h1><?php echo $this->vendor->vendor_store_name; ?></h1>
    </div>
    <div class="d-flex flex-column flex-md-row gap-4 mb-4">
        <div class="flex-grow-1 flex-shrink-1">
            <div class="vendor-description">
                <?php echo $this->vendor->vendor_store_desc; ?>
            </div>
        </div>
        <?php if (!empty($this->vendor->images[0])) : ?>
            <div class="col-md-3 text-right flex-shrink-0">
                <div class="vendor-image">
                    <?php echo $this->vendor->images[0]->displayMediaThumb('', false); ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
    <div class="vendor-contact-info mb-4">
        <?php echo shopFunctionsF::renderVendorAddress($this->vendor->virtuemart_vendor_id, '<br />', $vendorFieldSkips); ?>
    </div>
    <?php if (!empty($this->vendor->vendor_legal_info)) : ?>
        <div class="vendor-legal-info mb-4">
            <?php echo $this->vendor->vendor_legal_info; ?>
        </div>
    <?php endif; ?>
    <ul class="vendor-links list-unstyled">
        <li><?php echo $this->linktos; ?></li>
        <li><?php echo $this->linkcontact; ?></li>
    </ul>
</div>
