<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
**/

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Router\Route;

defined('_JEXEC') or die;

$vendorFieldSkips = property_exists($this, 'vendorFieldSkips') ? $this->vendorFieldSkips : [];
$min              = VmConfig::get('asks_minimum_comment_length', 50);
$max              = VmConfig::get('asks_maximum_comment_length', 2000) ;
$askComment       = vmText::sprintf('COM_VIRTUEMART_ASK_COMMENT', $min, $max);

vmJsApi::JvalideForm();
vmJsApi::addJScript('askform', '
    jQuery(function($){
            $("#askform").validationEngine("attach");
            $("#comment").keyup( function () {
                var result = $(this).val();
                    $("#counter").val( result.length );
            });
    });
');
?>
<div class="vendor-details-view vendor-details-view-contact">
    <div class="page-header">
        <h1><?php echo $this->vendor->vendor_store_name; ?></h1>
    </div>
    <div class="vendor-contact-info mb-4">
        <?php echo shopFunctionsF::renderVendorAddress($this->vendor->virtuemart_vendor_id, '<br />', $vendorFieldSkips); ?>
    </div>
    <h4>
        <?php echo vmText::_('COM_VIRTUEMART_VENDOR_ASK_QUESTION'); ?>
    </h4>
    <div class="form-field">
       <form method="post" class="form-validate" action="<?php echo Route::_('index.php') ; ?>" name="askform" id="askform">
            <div class="mb-3 form-group">
                <label for="name" class="form-label">
                    <?php echo vmText::_('COM_VIRTUEMART_USER_FORM_NAME'); ?>
                </label>
                <input type="text" class="form-control validate[required,minSize[4],maxSize[64]]" value="<?php echo $this->user->name ?>" name="name" id="name" size="30" validation="required name" required/>
            </div>
            <div class="mb-3 form-group">
                <label for="email" class="form-label">
                    <?php echo vmText::_('COM_VIRTUEMART_USER_FORM_EMAIL'); ?>
                </label>
                <input type="text" class="form-control validate[required,custom[email]]" value="<?php echo $this->user->email ?>" name="email" id="email" size="30" validation="required email" required />
            </div>
            <div class="mb-4 form-group">
                <label for="comment" class="form-label">
                    <?php echo $askComment; ?>
                </label>
                <textarea title="<?php echo $askComment ?>" class="form-control validate[required,minSize[<?php echo $min ?>],maxSize[<?php echo $max ?>]] field" id="comment" name="comment" cols="30" rows="10" required></textarea>
            </div>
            
            <div class="d-flex flex-column gap-3 mb-4">
                <?php echo $this->captcha; ?>

                <div class="d-flex gap-3 flex-wrap justify-content-between align-items-center">
                    <input class="btn btn-primary btn-lg" type="submit" name="submit_ask" title="<?php echo vmText::_('COM_VIRTUEMART_ASK_SUBMIT')  ?>" value="<?php echo vmText::_('COM_VIRTUEMART_ASK_SUBMIT')  ?>" />
                    <div class="d-flex flex-row flex-shrink-1 align-items-center gap-3">
                        <label for="characterCount" class="col-form-label text-nowrap">
                            <?php echo vmText::_('COM_VIRTUEMART_ASK_COUNT'); ?>
                        </label>
                        <input type="text" value="0" size="4" class="form-control readonly counter" id="counter" name="counter" maxlength="4" disabled />
                    </div>
                </div>  
            </div>
            <input type="hidden" name="view" value="vendor" />
            <input type="hidden" name="virtuemart_vendor_id" value="<?php echo $this->vendor->virtuemart_vendor_id ?>" />
            <input type="hidden" name="option" value="com_virtuemart" />
            <input type="hidden" name="task" value="mailAskquestion" />
            <?php echo HTMLHelper::_('form.token'); ?>
        </form>
    </div>
    <ul class="vendor-links list-unstyled">
        <li><?php echo $this->linkdetails; ?></li>
        <li><?php echo $this->linktos; ?></li>
    </ul>
</div>
