<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;
?>
<?php if ($this->userDetails->user_is_vendor || $this->allowRegisterVendor || !empty($this->userDetails->virtuemart_user_id)) : ?>
    <fieldset>
        <legend class="userfields_info">
            <?php echo vmText::_('COM_VIRTUEMART_SHOPPER_FORM_LBL'); ?>
        </legend>
        <?php if (Vmconfig::get('multix', 'none') !== 'none') : ?>
            <?php if ($this->userDetails->user_is_vendor || $this->allowRegisterVendor) : ?>
                <div class="control-group">
                    <div class="control-label">
                        <label for="virtuemart_vendor_id" class="form-label">
                            <?php echo vmText::_('COM_VIRTUEMART_PRODUCT_FORM_VENDOR') ?>:
                        </label>
                    </div>
                    <div class="controls">
                        <?php if ($this->userDetails->user_is_vendor) : ?>
                            <?php echo $this->lists['vendors']; ?>
                        <?php else : ?>
                            <?php echo VmHtml::checkbox('user_is_vendor', $this->userDetails->user_is_vendor, 1, 0, '', 'user_is_vendor'); ?>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>
        <?php endif; ?>

        <?php if (!empty($this->userDetails->virtuemart_user_id)) : ?>
            <div class="control-group">
                <div class="control-label">
                    <label for="customer_number" class="form-label">
                        <?php echo vmText::_('COM_VIRTUEMART_USER_FORM_CUSTOMER_NUMBER'); ?>:
                    </label>
                </div>
                <div class="controls">
                    <?php if (vmAccess::manager('user.edit')) : ?>
                        <input type="text" name="customer_number" id="customer_number" size="40" value="<?php echo $this->lists['custnumber']; ?>" />
                    <?php else : ?>
                        <input type="text" name="customer_number" id="customer_number" size="40" value="<?php echo $this->lists['custnumber']; ?>" disabled />
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($this->lists['shoppergroups'] && !empty($this->userDetails->virtuemart_user_id)) : ?>
            <div class="control-group">
                <div class="control-label">
                    <label for="virtuemart_shoppergroup_id" class="form-label">
                        <?php echo vmText::_('COM_VIRTUEMART_SHOPPER_FORM_GROUP'); ?>:
                    </label>
                </div>
                <div class="controls">
                    <?php echo $this->lists['shoppergroups']; ?>
                </div>
            </div>
        <?php endif; ?>
        
    </fieldset>
<?php endif; ?>