<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\HTML\HTMLHelper;

defined('_JEXEC') or die;
?>
<?php if (!vmAccess::manager('user.editshop')) : ?>
    <div class="alert alert-warning" role="alert">
        <?php echo vmText::_('COM_VM_PERM_MISSING_VENDOR'); ?>
    </div>
<?php endif; ?>
<fieldset>
    <legend>
        <?php echo vmText::_('COM_VIRTUEMART_VENDOR_FORM_INFO_LBL'); ?>
    </legend>
    <div class="control-group">
        <div class="control-label">
            <label for="vendor_name" class="form-label">
                <?php echo vmText::_('COM_VIRTUEMART_STORE_FORM_COMPANY_NAME'); ?>:
            </label>
        </div>
        <div class="controls">
            <input type="text" name="vendor_name" id="vendor_name" value="<?php echo $this->vendor->vendor_name; ?>" />
        </div>
    </div>
    <div class="control-group">
        <div class="control-label">
            <label for="vendor_store_name" class="form-label">
                <?php echo vmText::_('COM_VIRTUEMART_STORE_FORM_STORE_NAME'); ?>:
            </label>
        </div>
        <div class="controls">
            <input type="text" name="vendor_store_name" id="vendor_store_name" value="<?php echo $this->vendor->vendor_store_name; ?>" />
        </div>
    </div>
    <div class="control-group">
        <div class="control-label">
            <label for="vendor_url" class="form-label">
                <?php echo vmText::_('COM_VIRTUEMART_PRODUCT_FORM_URL'); ?>:
            </label>
        </div>
        <div class="controls">
            <input type="text" name="vendor_url" id="vendor_url" value="<?php echo $this->vendor->vendor_url; ?>" />
        </div>
    </div>
    <div class="control-group">
        <div class="control-label">
            <label for="vendor_min_pov" class="form-label">
                <?php echo vmText::_('COM_VIRTUEMART_STORE_FORM_MPOV'); ?>:
            </label>
        </div>
        <div class="controls">
            <input type="text" name="vendor_min_pov" id="vendor_min_pov" value="<?php echo $this->vendor->vendor_min_pov; ?>" />
        </div>
    </div>
</fieldset>
<fieldset>
    <legend>
        <?php echo vmText::_('COM_VIRTUEMART_STORE_CURRENCY_DISPLAY'); ?>
    </legend>
    <div class="control-group">
        <div class="control-label">
            <label for="vendor_currency" class="form-label">
                <?php echo vmText::_('COM_VIRTUEMART_CURRENCY'); ?>:
            </label>
        </div>
        <div class="controls">
            <?php echo HTMLHelper::_('select.genericlist', $this->currencies, 'vendor_currency', 'class="vm-chzn-select"', 'virtuemart_currency_id', 'currency_name', $this->vendor->vendor_currency, 'vendor_currency'); ?>
        </div>
    </div>
    <div class="control-group">
        <div class="control-label">
            <label for="vendor_accepted_currencies" class="form-label">
                <?php echo vmText::_('COM_VIRTUEMART_STORE_FORM_ACCEPTED_CURRENCIES'); ?>:
            </label>
        </div>
        <div class="controls">
            <?php echo HTMLHelper::_('select.genericlist', $this->currencies, 'vendor_accepted_currencies[]', 'size=10 multiple="multiple" class="vm-chzn-select"', 'virtuemart_currency_id', 'currency_name', $this->vendor->vendor_accepted_currencies, 'vendor_accepted_currencies'); ?>
        </div>
    </div>
</fieldset>
<fieldset>
    <legend>
        <?php echo vmText::_('COM_VIRTUEMART_VENDOR_FORM_INFO_LBL'); ?>
    </legend>
    <?php echo $this->vendor->images[0]->displayFilesHandler($this->vendor->virtuemart_media_id, 'vendor'); ?>
</fieldset>
<fieldset>
    <legend>
        <?php echo vmText::_('COM_VIRTUEMART_STORE_FORM_DESCRIPTION'); ?>
    </legend>
    <?php echo $this->editor->display('vendor_store_desc', $this->vendor->vendor_store_desc, '100%', 450, 70, 15); ?>
</fieldset>
<fieldset>
    <legend>
        <?php echo vmText::_('COM_VIRTUEMART_STORE_FORM_TOS'); ?>
    </legend>
    <?php echo $this->editor->display('vendor_terms_of_service', $this->vendor->vendor_terms_of_service, '100%', 450, 70, 15); ?>
</fieldset>
<fieldset>
    <legend>
        <?php echo vmText::_('COM_VIRTUEMART_STORE_FORM_LEGAL'); ?>
    </legend>
    <?php echo $this->editor->display('vendor_legal_info', $this->vendor->vendor_legal_info, '100%', 400, 70, 15); ?>
</fieldset>

<input type="hidden" name="user_is_vendor" value="1" />
<input type="hidden" name="virtuemart_vendor_id" value="<?php echo $this->vendor->virtuemart_vendor_id; ?>" />
<input type="hidden" name="last_task" value="<?php echo vRequest::getCmd('task'); ?>" />
