<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Router\Route;

defined('_JEXEC') or die;
?>
<div class="table-responsive mb-5">
    <table class="table table-striped table-condensed">
        <thead>
            <tr>
                <th class="align-left">
                    <?php echo vmText::_('COM_VIRTUEMART_ORDER_LIST_ORDER_NUMBER'); ?>
                </th>
                <th class="align-center">
                    <?php echo vmText::_('COM_VIRTUEMART_ORDER_LIST_CDATE'); ?>
                </th>
                <th class="align-center d-none d-md-table-cell">
                    <?php echo vmText::_('COM_VIRTUEMART_ORDER_LIST_MDATE'); ?>
                </th>
                <th class="align-center">
                    <?php echo vmText::_('COM_VIRTUEMART_ORDER_LIST_STATUS'); ?>
                </th>
                <th class="align-right">
                    <?php echo vmText::_('COM_VIRTUEMART_ORDER_LIST_TOTAL'); ?>
                </th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($this->orderlist as $i => $row) : ?>
                <?php $editlink = Route::_('index.php?option=com_virtuemart&view=orders&layout=details&order_number=' . $row->order_number); ?>
                <tr>
                    <td class="align-left">
                        <a href="<?php echo $editlink; ?>" rel="nofollow"><?php echo $row->order_number; ?></a>
                    </td>
                    <td class="align-center">
                        <?php echo HTMLHelper::_('date', $row->created_on); ?>
                    </td>
                    <td class="align-center d-none d-md-table-cell">
                        <?php echo HTMLHelper::_('date', $row->modified_on); ?>
                    </td>
                    <td class="align-center">
                        <?php echo shopFunctionsF::getOrderStatusName($row->order_status); ?>
                    </td>
                    <td class="align-right text-nowrap">
                        <?php echo $this->currency->priceDisplay($row->order_total); ?>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
