<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\HTML\HTMLHelper;
use Virtueplanet\Plugin\System\Prime\Service\HTML\Virtuemart;

defined('_JEXEC') or die;

// When only one Delimiter exists, set it to begin of the array
$dField = null;
$pos    = null;
$i      = 0;

foreach ($this->userFields['fields'] as $key => $field) {
    if ($field['type'] == 'delimiter') {
        $dField = $field;
        $pos    = $key;
        $i++;
    }

    if ($i > 1) {
        $dField = null;
        break;
    }
}

if ($dField) {
    unset($this->userFields['fields'][$pos]);
    array_unshift($this->userFields['fields'], $dField);
}

$serviceRegistry = HTMLHelper::getServiceRegistry();

if (!$serviceRegistry->hasService('vpprime_virtuemart')) {
    $serviceRegistry->register('vpprime_virtuemart', Virtuemart::class);
}

$closeFieldset = false;
$hiddenFields  = [];
$position      = 0
?>
<?php foreach ($this->userFields['fields'] as $field) : ?>
    <?php if ($field['type'] === 'delimiter') : ?>
        <?php if ($closeFieldset) : ?>
            <?php echo '</fieldset>' . "\n"; ?>
        <?php endif; ?>

        <?php if ($field['name'] === 'delimiter_userinfo') : ?>
            <?php if ($this->getLayout() === 'edit') : ?>
                <?php echo $this->loadTemplate('vmshopper'); ?>
            <?php endif; ?>
        <?php else : ?>
            <?php echo '<fieldset>' . "\n"; ?>
            <?php echo '<legend>' . $field['title'] . '</legend>' . "\n"; ?>
            <?php $closeFieldset = true; ?>
        <?php endif; ?>
    <?php elseif ($field['hidden']) : ?>
        <?php $hiddenFields[] = $field['formcode']; ?>
    <?php else : ?>
        <?php if ($position === 0) : ?>
            <?php echo '<fieldset>' . "\n"; ?>
            <?php $closeFieldset = true; ?>
        <?php endif; ?>

        <?php $title = empty($field['description']) ? $field['title'] : strip_tags($field['description']); ?>
        <div class="control-group">
            <div class="control-label">
                <label class="form-label <?php echo $field['name']; ?>-label" for="<?php echo $field['name']; ?>_field">
                    <span class="has-tooltip" title="<?php echo $title; ?>">
                        <?php echo $field['title'] . ($field['required'] ? ' <span class="asterisk" aria-hidden="true">*</span>' : ''); ?>
                    </span>
                </label>
            </div>
            <div class="controls">
                <?php if ($field['name'] === 'password') : ?>
                    <?php echo HTMLHelper::_('vpprime_virtuemart.password', $field['name'], $field['value'], ['id' => $field['name'] . '_field', 'required' => $field['required'], 'rules' => true, 'meter' => true]); ?>
                <?php elseif ($field['name'] === 'password2') : ?>
                    <?php echo HTMLHelper::_('vpprime_virtuemart.password', $field['name'], $field['value'], ['id' => $field['name'] . '_field', 'required' => $field['required']]); ?>
                <?php else : ?>
                    <?php echo $field['formcode']; ?>
                <?php endif; ?>
            </div>
        </div>
    <?php endif; ?>
    
    <?php $position++; ?>
<?php endforeach; ?>

<?php if ($closeFieldset) : ?>
    <?php echo '</fieldset>' . "\n"; ?>
<?php endif; ?>

<?php !empty($hiddenFields) ? implode("\n", $hiddenFields) : ''; ?>
