<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Router\Route;

defined('_JEXEC') or die;

$cart             = VirtueMartCart::getCart();
$returnView       = $cart->_fromCart || $cart->getInCheckOut() ? 'cart' : 'user';
$task             = $cart->getInCheckOut() ? '&task=checkout' : '';
$returnUrl        = 'index.php?option=com_virtuemart&view=' . $returnView . $task;
$showRegistration = VmConfig::get('oncheckout_show_register', 1) && Factory::getUser()->guest && $this->address_type == 'BT' && $returnView == 'cart';
$showRegistration = property_exists($this, 'showRegistration') ? $this->showRegistration : $showRegistration;
$showRegisterText = VmConfig::get('oncheckout_show_register', 1) && Factory::getUser()->guest && !VmConfig::get('oncheckout_only_registered', 0) && $this->address_type == 'BT' && $returnView == 'cart';
$showRegisterText = property_exists($this, 'showRegisterText') ? $this->showRegisterText : $showRegisterText;
?>
<div class="page-container-box">
    <div class="page-header">
        <h1><?php echo $this->page_title; ?></h1>
    </div>

    <div class="payments-signin-button" aria-hidden="true"></div>

    <?php echo shopFunctionsF::getLoginForm(true, false, $returnUrl); ?>

    <h2 class="sub-heading">
        <?php echo $this->address_type == 'BT' ? vmText::_('COM_VIRTUEMART_USER_FORM_EDIT_BILLTO_LBL') : vmText::_('COM_VIRTUEMART_USER_FORM_ADD_SHIPTO_LBL'); ?>
    </h2>

    <form action="<?php echo Route::_('index.php?option=com_virtuemart&view=user', $this->useXHTML, $this->useSSL) ?>" method="post" id="userForm" name="userForm" class="form-validate old-form">
        <?php echo $this->loadTemplate('userfields'); ?>

        <?php if (VmConfig::get('reg_captcha') && Factory::getUser()->guest) : ?>
            <div id="recaptcha_wrapper">
                <div class="control-group">
                    <div class="controls">
                        <?php echo $this->captcha; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($this->userDetails->virtuemart_user_id) : ?>
            <?php echo $this->loadTemplate('addshipto'); ?>
        <?php endif; ?>

        <?php if ($showRegisterText) : ?>
            <div class="control-group">
                <p class="reg_text p-3 bg-light text-dark text-center">
                    <?php echo vmText::sprintf('COM_VIRTUEMART_ONCHECKOUT_DEFAULT_TEXT_REGISTER', vmText::_('COM_VIRTUEMART_REGISTER_AND_CHECKOUT'), vmText::_('COM_VIRTUEMART_CHECKOUT_AS_GUEST')) ?>
                </p>
            </div>
        <?php endif; ?>

        <?php if ($showRegistration) : ?>
            <div class="control-group">
                <button name="register" class="btn btn-primary w-100" type="submit" onclick="return vmValidator.validate(userForm, true);">
                    <?php echo vmText::_('COM_VIRTUEMART_REGISTER_AND_CHECKOUT'); ?>
                </button>
            </div>
            <?php if (!VmConfig::get('oncheckout_only_registered', 0)) : ?>
                <div class="control-group">
                    <button name="save" class="btn btn-primary w-100" type="submit" onclick="return vmValidator.validate(userForm, false);">
                        <?php echo vmText::_('COM_VIRTUEMART_CHECKOUT_AS_GUEST'); ?>
                    </button>
                </div>
            <?php endif; ?>
            <div class="control-group">
                <button class="btn btn-secondary w-100" type="reset" onclick="window.location.href='<?php echo Route::_('index.php?option=com_virtuemart&view=' . $returnView . '&task=cancel'); ?>'">
                    <?php echo vmText::_('COM_VIRTUEMART_CANCEL'); ?>
                </button>
            </div>
        <?php else : ?>
            <div class="control-group">
                <button name="submit" class="btn btn-primary w-100" type="submit" onclick="return vmValidator.validate(userForm, true);">
                    <?php echo vmText::_('COM_VIRTUEMART_SAVE'); ?>
                </button>
            </div>
            <div class="control-group">
                <button class="btn btn-secondary w-100" type="reset" onclick="window.location.href='<?php echo Route::_('index.php?option=com_virtuemart&view=' . $returnView . '&task=cancel'); ?>'">
                    <?php echo vmText::_('COM_VIRTUEMART_CANCEL'); ?>
                </button>
            </div>
        <?php endif; ?>

        <input type="hidden" name="option" value="com_virtuemart"/>
        <input type="hidden" name="view" value="user"/>
        <input type="hidden" name="controller" value="user"/>
        <input type="hidden" name="task" value="saveUser"/>
        <input type="hidden" name="layout" value="<?php echo method_exists($this, 'getBaseLayout') ? $this->getBaseLayout() : $this->getLayout(); ?>"/>
        <input type="hidden" name="address_type" value="<?php echo $this->address_type; ?>"/>
        <?php if (!empty($this->virtuemart_userinfo_id)) : ?>
            <input type="hidden" name="shipto_virtuemart_userinfo_id" value="<?php echo (int) $this->virtuemart_userinfo_id; ?>" />
        <?php endif; ?>
        <?php echo HTMLHelper::_('form.token'); ?>
    </form>
</div>

<?php if (!empty($this->userFields['functions'])) {
    echo '<script>' . "\n";
    echo join("\n", $this->userFields['functions']);
    echo '</script>' . "\n";
} ?>
