<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

defined('_JEXEC') or die;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app              = Factory::getApplication();
$user             = Factory::getUser();
$document         = $app->getDocument();
$wa               = $document->getWebAssetManager();
$url              = vmURI::getCurrentUrlBy('request');
$cancelUrl        = Route::_($url . '&task=cancel');
$tabs             = [];
$showRegistration = property_exists($this, 'showRegistration') ? $this->showRegistration : true;

if (!empty($this->userDetails->virtuemart_user_id)) {
    $wa->useScript('bootstrap.tab');

    $tabs[] = [
        'id'       => 'tab-shopper',
        'template' => 'shopper',
        'title'    => 'COM_VIRTUEMART_SHOPPER_FORM_LBL',
        'active'   => true
    ];

    if ($this->userDetails->user_is_vendor) {
        $tabs[] = [
            'id'       => 'tab-vendor',
            'template' => 'vendor',
            'title'    => 'COM_VIRTUEMART_VENDOR',
            'active'   => false
        ];
    }

    if (!empty($this->shipto)) {
        $tabs[] = [
            'id'       => 'tab-shipto',
            'template' => 'shipto',
            'title'    => 'COM_VIRTUEMART_USER_FORM_ADD_SHIPTO_LBL',
            'active'   => false
        ];
    }

    if (!empty($this->orderlist)) {
        $tabs[] = [
            'id'       => 'tab-orderlist',
            'template' => 'orderlist',
            'title'    => 'COM_VIRTUEMART_YOUR_ORDERS',
            'active'   => false
        ];
    }
}

$shopManageUrl = Uri::root() . 'index.php?option=com_virtuemart&view=virtuemart&tmpl=component&managing=1';
$addProductUrl = Uri::root() . 'index.php?option=com_virtuemart&tmpl=component&view=product&view=product&task=edit&virtuemart_product_id=0&managing=1';
?>
<div class="<?php echo $user->guest ? 'page-container-box' : 'page-container'; ?>">
    <div class="page-header">
        <h1><?php echo $this->page_title; ?></h1>
    </div>

    <?php echo shopFunctionsF::getLoginForm(false, false); ?>

    <?php if (empty($this->userDetails->virtuemart_user_id) && $showRegistration) : ?>
        <h2 class="sub-heading"><?php echo vmText::_('COM_VIRTUEMART_YOUR_ACCOUNT_REG'); ?></h2>
    <?php endif; ?>

    <form method="post" id="adminForm" name="userForm" action="<?php echo Route::_($url); ?>" class="form-validate old-form">
        <?php if (!empty($this->userDetails->virtuemart_user_id)) : ?>
            <?php if (vmAccess::isFEmanager() || vmAccess::isFEmanager(['product.add', 'product.edit'])) : ?>
                <div class="d-flex justify-content-end gap-1 mb-4">
                    <?php if (vmAccess::isFEmanager()) : ?>
                        <a href="<?php echo $shopManageUrl; ?>" class="btn btn-secondary"><?php echo vmText::_('JACTION_MANAGE'); ?></a>&nbsp;
                    <?php endif; ?>

                    <?php if (vmAccess::isFEmanager(['product.add', 'product.edit'])) : ?>
                        <a href="<?php echo $addProductUrl; ?>" class="btn btn-secondary"><?php echo vmText::_('COM_VIRTUEMART_PRODUCT_ADD_PRODUCT'); ?></a>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

            <ul class="nav nav-tabs-basic mb-4" id="user-information-tab" role="tablist">
                <?php foreach ($tabs as $tab) : ?>
                    <li class="nav-item" role="presentation">
                        <button type="button" data-bs-target="#<?php echo $tab['id']; ?>" id="<?php echo $tab['id']; ?>-tab" class="nav-link<?php echo $tab['active'] ? ' active' : ''; ?>" data-bs-toggle="tab" role="tab" aria-controls="<?php echo $tab['id']; ?>" aria-selected="<?php echo $tab['active'] ? 'true' : 'false'; ?>"><?php echo vmText::_($tab['title']); ?></button>
                    </li>
                <?php endforeach; ?>
            </ul>
            <div class="tab-content">
                <?php foreach ($tabs as $tab) : ?>
                    <div class="tab-pane <?php echo $tab['active'] ? ' active' : ''; ?>" id="<?php echo $tab['id']; ?>" role="tabpanel" aria-labelledby="<?php echo $tab['id']; ?>-tab">
                        <?php echo $this->loadTemplate($tab['template']); ?>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php elseif ($showRegistration) : ?>
            <?php echo $this->loadTemplate('shopper'); ?>
        <?php endif; ?>

        <?php if (VmConfig::get('reg_captcha') && Factory::getUser()->guest) : ?>
            <div id="recaptcha_wrapper">
                <div class="control-group">
                    <div class="controls">
                        <?php echo $this->captcha; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if (!empty($this->userDetails->virtuemart_user_id) || $showRegistration) : ?>
            <div class="control-group">
                <button type="submit" class="btn btn-primary w-100" onclick="return vmValidator.validate(userForm, true);">
                    <?php echo $this->button_lbl; ?>
                </button>
            </div>

            <div class="control-group">
                <button type="reset" class="btn btn-secondary w-100" onclick="window.location.href='<?php echo $cancelUrl; ?>';">
                    <?php echo vmText::_('COM_VIRTUEMART_CANCEL'); ?>
                </button>
            </div>
        <?php endif; ?>

        <input type="hidden" name="option" value="com_virtuemart" />
        <input type="hidden" name="controller" value="user" />
        <?php echo HTMLHelper::_('form.token'); ?>
    </form>
</div>
