<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;

defined('_JEXEC') or die;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app            = Factory::getApplication();
$input          = $app->input;
$option         = strtolower($input->getCmd('option', ''));
$view           = strtolower($input->getCmd('view', ''));
$categoryIds    = $input->get('virtuemart_category_id', array(0), 'ARRAY');
$categoryIds    = array_map('intval', $categoryIds);
$categoryIdHash = ($option == 'com_customfilters' && $view == 'products') ? 'customfilters' : md5(serialize($categoryIds));
$defaultLayout  = $app->getUserState('vpprime.vm.productsublayout.category.' . $categoryIdHash, 0);
$productsLayout = VmConfig::get('productsublayout', 'products');
$productsLayout = !empty($defaultLayout) ? $defaultLayout : $productsLayout;
$modeMap        = ['products' => 'grid', 'products_horizon' => 'list', 'products_slim' => 'list'];
$productsLayout = (empty($productsLayout) || !array_key_exists($productsLayout, $modeMap)) ? 'products' : $productsLayout;
$viewMode       = strtolower($input->getCmd('viewmode', $modeMap[$productsLayout]));
$switches       = ['grid' => new stdClass(), 'list' => new stdClass()];
$cleanUri       = clone Uri::getInstance();

$cleanUri->delVar('custom_parent_id');

if (!$cleanUri->getVar('clearCart', 0)) {
    $cleanUri->delVar('clearCart');
}

$cleanUri->delVar('productsublayout');

$uri    = clone $cleanUri;
$params = array_merge($uri->getQuery(true), ['viewmode' => 'grid']);

unset($params['tmpl']);

$query = $uri->buildQuery($params);

$uri->setQuery($query);

$switches['grid']->title  = Text::_('TPL_VP_NEOTERIC_VIEWMODE_GRID');
$switches['grid']->url    = htmlspecialchars(strip_tags($uri->toString()), ENT_COMPAT, 'UTF-8');
$switches['grid']->active = (bool) ($viewMode === 'grid');

$uri    = clone $cleanUri;
$params = array_merge($uri->getQuery(true), ['viewmode' => 'list']);

unset($params['tmpl']);

$query = $uri->buildQuery($params);

$uri->setQuery($query);

$switches['list']->title  = Text::_('TPL_VP_NEOTERIC_VIEWMODE_LIST');
$switches['list']->url    = htmlspecialchars(strip_tags($uri->toString()), ENT_COMPAT, 'UTF-8');
$switches['list']->active = (bool) ($viewMode === 'list');
?>
<div class="row gx-2 align-content-center">
    <div class="col-auto">
        <?php if ($switches['grid']->active) : ?>
            <span class="link-switch active show-tooltip" title="<?php echo $switches['grid']->title; ?>">
                <span class="fas fa-th" aria-hidden="true"></span>
                <span class="visually-hidden"><?php echo $switches['grid']->title; ?></span>
            </span>
        <?php else : ?>
            <a class="link-switch show-tooltip" href="<?php echo $switches['grid']->url; ?>" title="<?php echo $switches['grid']->title; ?>" rel="nofollow noopener">
                <span class="fas fa-th" aria-hidden="true"></span>
                <span class="visually-hidden"><?php echo $switches['grid']->title; ?></span>
            </a>
        <?php endif; ?>
    </div>
    <div class="col-auto">
        <?php if ($switches['list']->active) : ?>
            <span class="link-switch active show-tooltip" title="<?php echo $switches['list']->title; ?>">
                <span class="fas fa-th-list" aria-hidden="true"></span>
                <span class="visually-hidden"><?php echo $switches['list']->title; ?></span>
            </span>
        <?php else : ?>
            <a class="link-switch show-tooltip" href="<?php echo $switches['list']->url; ?>" title="<?php echo $switches['list']->title; ?>">
                <span class="fas fa-th-list" aria-hidden="true"></span>
                <span class="visually-hidden"><?php echo $switches['list']->title; ?></span>
            </a>
        <?php endif; ?>
    </div>
</div>
