<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\HTML\HTMLHelper;

defined('_JEXEC') or die;

$product    = $viewData['product'];
$isWishlist = isset($viewData['isWishlist']) ? $viewData['isWishlist'] : false;
$vmeEnabled = defined('VMESSENTIALS_ADMINISTRATOR');
$vmeParams  = ComponentHelper::getParams('com_vmessentials');
?>
<?php if ($vmeEnabled && ($vmeParams->get('enable_wishlist', 1) || $vmeParams->get('enable_compare', 1) || $vmeParams->get('enable_quickview', 1))) : ?>
    <div class="product-list-utilities">
        <?php if ($vmeParams->get('enable_wishlist', 1) && !$isWishlist) : ?>
            <div class="product-list-utility-item">
                <?php echo HTMLHelper::_('vmessentials.addtowishlist', $product, true); ?>
            </div>
        <?php endif; ?>
        <?php if ($vmeParams->get('enable_compare', 1)) : ?>
            <div class="product-list-utility-item">
                <?php echo HTMLHelper::_('vmessentials.addtocompare', $product, true); ?>
            </div>
        <?php endif; ?>
        <?php if ($vmeParams->get('enable_quickview', 1)) : ?>
            <div class="product-list-utility-item">
                <?php echo HTMLHelper::_('vmessentials.quickview', $product, true); ?>
            </div>
        <?php endif; ?>
    </div>
<?php endif; ?>