<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\Utilities\ArrayHelper;

defined('_JEXEC') or die;

$prefix  = isset($viewData['prefix']) ? $viewData['prefix'] : 0;
$field   = $viewData['field'];
$value   = $field['value'];
$name    = $prefix . $field['name'];
$idTag   = preg_replace("/[^\\w.-]/", "", $prefix . $field['name'] . '_field');
$class   = 'terms-of-service';
$attribs = [];

if (VmConfig::isSiteByApp()) {
    $cart = VirtuemartCart::getCart();
    $cart->prepareVendor();

    if (empty($value) && !VmConfig::get('agree_to_tos_onorder', true)) {
        if (is_array($cart->BT) && !empty($cart->BT['tos'])) {
            $value = $cart->BT['tos'];
        }
    }
}

$attribs['class'] = 'form-check-input';

if (!empty($field['required'])) {
    $class              .= ' required';
    $attribs['class']   .= ' required';
    $attribs['required'] = 'required';
}

$attribs = ArrayHelper::toString($attribs);
?>
<?php if (VmConfig::isSiteByApp()) : ?>
    <div class="form-check">
        <?php echo VmHtml::checkbox($name, $value, 1, 0, $attribs, $idTag); ?>
        <label class="form-check-label" for="<?php echo $idTag; ?>">
            <a href="<?php echo Route::_('index.php?option=com_virtuemart&view=vendor&layout=tos&virtuemart_vendor_id=1', false); ?>" class="terms-of-service" target="_blank" data-bs-target="#modal-<?php echo $idTag; ?>" data-bs-toggle="modal">
                <?php echo vmText::_('COM_VIRTUEMART_CART_TOS_READ_AND_ACCEPTED') ?>
            </a>
        </label>
    </div>

    <div class="modal modal-lg fade" id="modal-<?php echo $idTag; ?>" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo vmText::_('COM_VIRTUEMART_CART_TOS'); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="<?php echo vmText::_('JLIB_HTML_BEHAVIOR_CLOSE'); ?>"></button>
                </div>
                <div class="modal-body">
                    <?php echo $cart->vendor->vendor_terms_of_service; ?>
                </div>
            </div>
        </div>
    </div>
<?php else : ?>
    <?php echo VmHtml::checkbox($name, $value, 1, 0, 'class="' . $class . '"', 'tos'); ?>
<?php endif; ?>
