<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Uri\Uri;

defined('_JEXEC') or die;

$product       = $viewData['product'];
$stockhandle   = VmConfig::get('stockhandle_products', false) && $product->product_stockhandle ? $product->product_stockhandle : VmConfig::get('stockhandle', 'none');
$availableDate = !empty($product->product_available_date) ? Factory::getDate($product->product_available_date) : null;
$currentDate   = Factory::getDate();
$imageFilePath = JPATH_BASE . '/' . VmConfig::get('assets_general_path') . 'images/availability/';
$imageUrlBase  = Uri::root() . VmConfig::get('assets_general_path') . 'images/availability/';
?>
<?php if (($product->product_in_stock - $product->product_ordered) < 1) : ?>
    <?php if ($availableDate && $availableDate->toUnix() > 0 && $currentDate < $availableDate) : ?>
        <div class="availability mt-4">
        <span><?php echo vmText::_('COM_VIRTUEMART_PRODUCT_AVAILABLE_DATE'); ?>:</span>&nbsp;<span class="text-muted"><?php echo HTMLHelper::_('date', $product->product_available_date, vmText::_('DATE_FORMAT_LC4')); ?></span>
        </div>
    <?php elseif ($stockhandle == 'risetime' && VmConfig::get('rised_availability') && empty($product->product_availability)) : ?>
        <div class="availability mt-4">
            <?php if (file_exists($imageFilePath . VmConfig::get('rised_availability'))) : ?>
                <?php echo HTMLHelper::_('image', $imageUrlBase . VmConfig::get('rised_availability', '7d.gif'), VmConfig::get('rised_availability', '7d.gif')); ?>
            <?php else : ?>
                <?php echo vmText::_(VmConfig::get('rised_availability')); ?>
            <?php endif; ?>
        </div>
    <?php elseif (!empty($product->product_availability)) : ?>
        <div class="availability mt-4">
            <?php if (file_exists($imageFilePath . $product->product_availability)) : ?>
                <?php echo HTMLHelper::_('image', $imageUrlBase . $product->product_availability, $product->product_availability, ['class' => 'availability-image']); ?>
            <?php else : ?>
                <?php echo vmText::_($product->product_availability); ?>
            <?php endif; ?>
        </div>
    <?php endif; ?>
<?php elseif ($availableDate && $availableDate->toUnix() > 0 && $currentDate < $availableDate) : ?>
    <div class="availability mt-4">
        <span><?php echo vmText::_('COM_VIRTUEMART_PRODUCT_AVAILABLE_DATE'); ?>:</span>&nbsp;<span class="text-muted"><?php echo HTMLHelper::_('date', $product->product_available_date, vmText::_('DATE_FORMAT_LC4')); ?></span>
    </div>
<?php endif; ?>
