<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

$product      = $viewData['product'];
$stockHandle  = VmConfig::get('stockhandle_products', false) && $product->product_stockhandle ? $product->product_stockhandle : VmConfig::get('stockhandle', 'none');
$stockLevel   = ($product->product_in_stock - $product->product_ordered);
$reorderLevel = $product->low_stock_notification;
$class        = 'normal-stock text-success';
$text         = vmText::_('TPL_VP_NEOTERIC_PRODUCT_IN_STOCK');
$tip          = vmText::_('COM_VIRTUEMART_STOCK_LEVEL_DISPLAY_NORMAL_TIP');

if ($stockHandle != 'none' && $stockLevel <= 0) {
    $class = 'no-stock text-danger';
    $text  = vmText::_('TPL_VP_NEOTERIC_PRODUCT_OUT_OF_STOCK');
    $tip   = vmText::_('COM_VIRTUEMART_STOCK_LEVEL_DISPLAY_OUT_TIP');
} elseif ($stockHandle != 'none' && $stockLevel <= $reorderLevel) {
    $class = 'low-stock text-warning';
    $text  = vmText::sprintf('TPL_VP_NEOTERIC_PRODUCT_LOW_STOCK', $stockLevel);
    $tip   = vmText::_('COM_VIRTUEMART_STOCK_LEVEL_DISPLAY_LOW_TIP');
}
?>
<span class="<?php echo $class; ?> has-tooltip" title="<?php echo $tip; ?>"><?php echo $text; ?></span>