<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 **/

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

defined('_JEXEC') or die;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app            = Factory::getApplication();
$document       = $app->getDocument();
$product        = $viewData['product'];
$currency       = $viewData['currency'];
$stockHandle    = VmConfig::get('stockhandle', 'none');
$productModel   = VmModel::getModel('product');
$ratingModel    = VmModel::getModel('Ratings');
$priceValidTill = Factory::getDate((string) $product->prices['product_price_publish_down']);
$today          = Factory::getDate();
$rating         = $ratingModel->getRatingByProduct($product->virtuemart_product_id);
$ratingCount    = is_object($rating) ? $rating->ratingcount : 0;
$description    = '';
$data           = [];

// Build structured data
$data['@context'] = 'https://schema.org/';
$data['@type']    = 'Product';
$data['name']     = vRequest::vmSpecialChars(strip_tags($product->product_name));

if (!empty($document->getMetaData('description'))) {
    $description = $document->getMetaData('description');
}

if (empty($description)) {
    if (!empty($product->product_s_desc)) {
        $description = $product->product_s_desc;
    } else {
        $description = $product->product_desc;
    }
}

$data['description'] = vRequest::vmSpecialChars(strip_tags($description));

if (VmConfig::get('show_manufacturers', 1) && !empty($product->mf_name)) {
    $data['brand'] = [
        '@type' => 'Thing',
        'name'  => $product->mf_name
    ];
}

if (!empty($product->product_sku)) {
    $data['productID'] = $product->product_sku;
    $data['sku']       = $product->product_sku;
}

if (!empty($product->product_mpn)) {
    $data['mpn'] = $product->product_mpn;
}

if (!empty($product->product_gtin)) {
    $data['gtin'] = $product->product_gtin;
}

if ($product->images[0]->virtuemart_media_id > 0) {
    if (count($product->images) === 1) {
        $data['image'] = Uri::root() . $product->images[0]->file_url;
    } else {
        $images = [];

        foreach ($product->images as $image) {
            if (empty($image->file_url) || !file_exists(JPATH_ROOT . '/' . $image->file_url)) {
                continue;
            }

            $images[] = Uri::root() . $image->file_url;
        }

        $data['image'] = $images;
    }
}

if (!empty($viewData['showRating']) && $ratingCount > 0) {
    $data['aggregateRating'] = [
        '@type'       => 'AggregateRating',
        'ratingValue' => floatval($product->rating),
        'ratingCount' => intval($ratingCount),
        'bestRating'  => VmConfig::get('vm_maximum_rating_scale', 5)
    ];
}

if (!empty($ratingModel->ids)) {
    $reviews = [];

    foreach ($ratingModel->ids as $customerReview) {
        if (!$customerReview->published) {
            continue;
        }

        $reviews[] = [
            '@type'         => 'Review',
            'datePublished' => Factory::getDate($customerReview->created_on)->format('Y-m-d'),
            'reviewBody'    => $customerReview->comment,
            'reviewRating'  => [
                '@type'       => 'Rating',
                'ratingValue' => floatval($customerReview->vote),
                'bestRating'  => (float) VmConfig::get('vm_maximum_rating_scale', 5)
            ],
            'author'        => [
                '@type' => 'Person',
                'name'  => $customerReview->name
            ]
        ];
    }

    if (!empty($reviews)) {
        if (count($reviews) === 1) {
            $data['review'] = $reviews[0];
        } else {
            $data['review'] = $reviews;
        }
    }
}

$data['offers']                  = [];
$data['offers']['@type']         = 'Offer';
$data['offers']['url']           = Uri::getInstance()->toString(['scheme', 'host', 'port']) . Route::_($product->canonical, false);
$data['offers']['price']         = $currency->roundForDisplay($product->prices['salesPrice']);
$data['offers']['priceCurrency'] = $currency->_vendorCurrency_code_3;
$data['offers']['itemCondition'] = 'https://schema.org/NewCondition';

if (!empty($product->customfieldsSorted['snippet'])) {
    foreach ($product->customfieldsSorted['snippet'] as $customfield) {
        $data['offers'][$customfield->custom_title] = $customfield->customfield_value;
    }
}

if (!empty($product->prices['product_price_publish_down']) && $priceValidTill > $today) {
    $data['offers']['priceValidUntil'] = $priceValidTill->format('Y-m-d');
}

if ($stockHandle == 'none') {
    // Always in stock
    $inStock = 1;
} elseif ($stockHandle == 'disableit_children' && $product->product_parent_id == 0) {
    $children = $productModel->getProductChilds($product->virtuemart_product_id);
    $inStock  = $product->product_in_stock - $product->product_ordered;

    foreach ($children as $child) {
        $inStock += $child->product_in_stock - $child->product_ordered;
    }
} else {
    $inStock = $product->product_in_stock - $product->product_ordered;
}

if ($inStock > 0) {
    $data['offers']['availability'] = 'https://schema.org/InStock';
} else {
    $data['offers']['availability'] = 'https://schema.org/OutOfStock';
}
?>
<script type="application/ld+json">
    <?php echo json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES); ?>
</script>