<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

defined('_JEXEC') or die;

$product    = $viewData['product'];
$vmeEnabled = defined('VMESSENTIALS_ADMINISTRATOR');
$vmeParams  = ComponentHelper::getParams('com_vmessentials');
?>
<?php if ($vmeEnabled && $vmeParams->get('enable_wishlist', 1)) : ?>
    <form action="<?php echo Route::_('index.php?option=com_vmessentials&view=wishlist') ?>" method="post" class="vmessentials-form">
        <a href="#" onclick="this.closest('form').submit();return false;"class="link-body">
            <span class="d-flex align-items-center gap-2">
                <i class="fas fa-times fa-lg" aria-hidden="true"></i>
                <?php echo Text::_('COM_VMESSENTIALS_REMOVE_FROM_WISHLIST') ?>
            </span>
        </a>
        <input type="hidden" name="option" value="com_vmessentials" />
        <input type="hidden" name="task" value="wishlist.remove" />
        <input type="hidden" name="virtuemart_product_id" value="<?php echo (int) $product->virtuemart_product_id; ?>" />
        <input type="hidden" name="product_name" value="<?php echo htmlspecialchars($product->product_name, ENT_COMPAT, 'UTF-8'); ?>" />
        <?php echo HTMLHelper::_('form.token'); ?>
        <?php echo HTMLHelper::_('vmessentials.returnUri'); ?>
    </form>
<?php endif; ?>
