<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
**/

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Virtueplanet\Plugin\System\Prime\Helper\VirtuemartHelper;

defined('_JEXEC') or die;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app         = Factory::getApplication();
$template    = $app->getTemplate(true);
$params      = $template->params;
$category    = $viewData['related'];
$customfield = $viewData['customfield'];
$lazyLoad    = $params->get('vm_image_lazyload', 1);
$imageClass  = $lazyLoad ? 'category-image lazy' : 'category-image';
$url         = Route::_('index.php?option=com_virtuemart&view=category&virtuemart_category_id=' . $category->virtuemart_category_id);
?>
<div class="item-container w-100 d-flex flex-column mb-4">
    <div class="category-image d-flex align-items-center justify-content-center mb-3">
        <a href="<?php echo $url ?>">
            <?php echo VirtuemartHelper::prepareLazyImageHTML($category->images[0]->displayMediaThumb('class="' . $imageClass . '"', false), $lazyLoad); ?>
        </a>
    </div>
    <h3 class="category-name text-center m-0 mb-3">
        <a href="<?php echo $url ?>"><?php echo vmText::_($category->category_name); ?></a>
    </h3>
    <div class="item-backdrop" aria-hidden="true" tabindex="-1"></div>
</div>

