<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 **/

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Virtueplanet\Plugin\System\Prime\Helper\VirtuemartHelper;

defined('_JEXEC') or die;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app         = Factory::getApplication();
$document    = $app->getDocument();
$template    = $app->getTemplate(true);
$params      = $template->params;
$product     = $viewData['related'];
$customfield = $viewData['customfield'];
$thumb       = $viewData['thumb'];
$lazyLoad    = $document->getType() === 'html' && $params->get('vm_image_lazyload', 1);
$imageClass  = $lazyLoad ? 'product-image tns-lazy-img' : 'product-image';
$currency    = CurrencyDisplay::getInstance();
$productLink = Route::_(VirtuemartHelper::getProductUrl($product));

// Do not show add to cart in ajax add to cart popup
if ($document->getType() !== 'html') {
    $customfield->waddtocart = false;
}

// Add the product information
$customfield->productInfo = $product;
?>
<div class="product-container" data-vm="product-container" data-ignore-dynamic="true">
    <?php if ($customfield->wImage) : ?>
        <div class="product-list-images mb-3 text-center">
            <a href="<?php echo $productLink; ?>">
                <?php echo VirtuemartHelper::prepareLazyImageHTML($product->images[0]->displayMediaThumb(['class' => $imageClass], false, '', true, false, false, $customfield->width, $customfield->height), $lazyLoad); ?>
            </a>
            <?php if ($document->getType() === 'html') : ?>
                <?php echo shopFunctionsF::renderVmSubLayout('productlabels', ['product' => $product]); ?>
                <?php echo shopFunctionsF::renderVmSubLayout('utilities', ['product' => $product]); ?>
            <?php endif; ?>
        </div>
    <?php endif; ?>
    <h3 class="product-name text-center m-0 mb-3">
        <a href="<?php echo $productLink; ?>"><?php echo $product->product_name; ?></a>
    </h3>
    <?php if ($customfield->wPrice) : ?>
        <div class="product-prices text-center mb-3">
            <?php echo shopFunctionsF::renderVmSubLayout('prices', ['product' => $product, 'currency' => $currency, 'showDetails' => false]); ?>
        </div>
    <?php endif; ?>
    <?php if ($customfield->wDescr && !empty($product->product_s_desc)) : ?>
        <div class="product-short-description text-center mb-3">
            <?php echo $product->product_s_desc; ?>
        </div>
    <?php endif; ?>
    <?php if ($customfield->waddtocart) : ?>
        <?php echo shopFunctionsF::renderVmSubLayout('addtocart', ['product' => $product, 'isList' => true, 'listMode' => 'grid']); ?>
    <?php endif; ?>
</div>