<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\Utilities\ArrayHelper;

defined('_JEXEC') or die;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app           = Factory::getApplication();
$template      = $app->getTemplate(true);
$params        = $template->params;
$product       = isset($viewData['product']) ? $viewData['product'] : null;
$rating        = isset($viewData['rating']) ? $viewData['rating'] : 0;
$show          = $viewData['showRating'];
$showCount     = isset($viewData['showCount']) ? (bool) $viewData['showCount'] : false;
$ratingModel   = VmModel::getModel('Ratings');
$productRating = $product && property_exists($product, 'virtuemart_product_id') ? $ratingModel->getRatingByProduct($product->virtuemart_product_id) : null;
$showReviews   = isset($viewData['showReviews']) ? (bool) $viewData['showReviews'] : true;
$showReviews   = $showReviews && $product && property_exists($product, 'virtuemart_product_id') ? $ratingModel->showReview($product->virtuemart_product_id) : false;
$ratingCount   = is_object($productRating) ? $productRating->ratingcount : 0;
$reviewCount   = 0;
$attribs       = [];

if (!empty($ratingModel->ids)) {
    foreach ($ratingModel->ids as $customerReview) {
        if (!$customerReview->published) {
            continue;
        }

        $reviewCount++;
    }
}

if (!empty($viewData['name'])) {
    $attribs['name'] = $viewData['name'];
}

if (!empty($viewData['id'])) {
    $attribs['id'] = $viewData['id'];
}

$attribs['max']         = VmConfig::get('vm_maximum_rating_scale', 5);
$attribs['rating']      = 0;
$attribs['unrated-msg'] = vmText::_('COM_VIRTUEMART_UNRATED');
$attribs['hint']        = vmText::_('COM_VIRTUEMART_RATING_TITLE');
$attribs['color']       = $params->get('rating_star_color', '#EABE12');
$attribs['size']        = isset($viewData['size']) ? (int) $viewData['size'] : 14;
$attribs['readonly']    = !empty($viewData['readonly']) ? 'true' : 'false';
$attribs['half']        = 'true';

if ($product && property_exists($product, 'rating')) {
    $attribs['rating'] = $product->rating;
} else {
    $attribs['rating'] = $rating;
}

$attribs['aria-label'] = !empty($attribs['rating']) ? vmText::_('COM_VIRTUEMART_RATING_TITLE') . ' ' . $attribs['rating'] : vmText::_('COM_VIRTUEMART_UNRATED');

$attributes = ArrayHelper::toString($attribs);

if ($show) {
    echo '<prime-rating ' . $attributes . '></prime-rating>';

    if ($showCount) {
        echo '<span class="rating-count text-muted">' . Text::plural('TPL_VP_NEOTERIC_RATING_COUNT_N', $ratingCount) . '</span>';

        if ($reviewCount && $showReviews) {
            echo '<span class="review-count text-muted ms-2"><a href="#product-reviews-tab" data-bs-tablink>' . Text::plural('TPL_VP_NEOTERIC_REVIEW_COUNT_N', $reviewCount) . '</a></span>';
        }
    }
}
