<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

defined('_JEXEC') or die;

$product    = $viewData['product'];
$currentUrl = Uri::getInstance()->toString(['scheme', 'host', 'port']) . Route::_($product ->canonical);
$platforms  = [
    'facebook' => [
        'baseUrl' => 'https://www.facebook.com/sharer/sharer.php',
        'label'   => 'Facebook social link',
        'icon'    => '<i class="fab fa-facebook-f" aria-hidden="true"></i>',
        'url'     => ''
    ],
    'twitter' => [
        'baseUrl' => 'https://twitter.com/share',
        'label'   => 'Twitter social link',
        'icon'    => '<i class="fab fa-twitter" aria-hidden="true"></i>',
        'url'     => ''
    ],
    'pinterest' => [
        'baseUrl' => 'https://pinterest.com/pin/create/button/',
        'label'   => 'Pinterest social link',
        'icon'    => '<i class="fab fa-pinterest-p" aria-hidden="true"></i>',
        'url'     => ''
    ],
    'linkedin' => [
        'baseUrl' => 'https://www.linkedin.com/shareArticle?mini=true',
        'label'   => 'Linkedin social link',
        'icon'    => '<i class="fab fa-linkedin-in" aria-hidden="true"></i>',
        'url'     => ''
    ],
    'telegram' => [
        'baseUrl' => 'https://telegram.me/share/url',
        'label'   => 'Telegram social link',
        'icon'    => '<i class="fab fa-telegram-plane" aria-hidden="true"></i>',
        'url'     => ''
    ],
    'whatsapp' => [
        'baseUrl' => 'https://wa.me/',
        'label'   => 'Whatsapp social link',
        'icon'    => '<i class="fab fa-whatsapp" aria-hidden="true"></i>',
        'url'     => ''
    ]
];

foreach ($platforms as $name => &$platform) {
    $uri    = clone Uri::getInstance($platform['baseUrl']);
    $params = [];

    switch ($name) {
        case 'facebook':
            $params['u'] = $currentUrl;
            break;
        case 'twitter':
            $params['url'] = $currentUrl;
            break;
        case 'pinterest':
            if (empty($product ->images[0])) {
                unset($platforms[$name]);
                break;
            }

            $params['url']         = $currentUrl;
            $params['media']       = Uri::root() . $product ->images[0]->file_url;
            $params['description'] = $product ->product_name;
            break;
        case 'linkedin':
            $params['url'] = $currentUrl;
            break;
        case 'telegram':
            $params['url'] = $currentUrl;
            break;
        case 'whatsapp':
            $params['text'] = $product ->product_name . ' - ' . $currentUrl;
            break;
    }

    $params = array_merge($uri->getQuery(true), $params);
    $query  = $uri->buildQuery($params);

    $uri->setQuery($query);

    $platform['url'] = htmlspecialchars($uri->toString(), ENT_QUOTES, 'UTF-8');
}
?>
<ul class="social-share-list">
    <?php foreach ($platforms as $name => &$platform) : ?>
        <li class="social-share-list-item">
            <?php echo HTMLHelper::_('link', $platform['url'], $platform['icon'], ['target' => '_blank', 'rel' => 'noopener noreferrer nofollow', 'class' => 'social-share-link social-share-link-' . $name, 'aria-label' => $platform['label']]); ?>
        </li>
    <?php endforeach; ?>
</ul>
