<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
**/

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Virtueplanet\Plugin\System\Prime\Helper\VirtuemartHelper;

defined('_JEXEC') or die;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app           = Factory::getApplication();
$currency      = $viewData['currency'];
$cellWidth     = [];
$template      = $app->getTemplate(true);
$params        = $template->params;
$showRating    = isset($viewData['showRating']) ? $viewData['showRating'] : true;
$showRating    = $showRating && $params->get('products_show_rating', 1);
$showPrice     = isset($viewData['showPrice']) ? $viewData['showPrice'] : true;
$showAddToCart = isset($viewData['showAddToCart']) ? $viewData['showAddToCart'] : $params->get('products_show_addtocart', 1);
$productModel  = VmModel::getModel('product');
$dynamic       = false;
$lazyLoad      = $params->get('vm_image_lazyload', 1);
$imageClass    = $lazyLoad ? 'product-image lazy' : 'product-image';

if (vRequest::getInt('dynamic', 0) && vRequest::getInt('virtuemart_product_id', 0)) {
    $dynamic = true;
}
?>
<?php foreach ($viewData['products'] as $type => $products) : ?>
    <?php if (!$dynamic && ((!empty($type) && count($products) > 0) || (count($viewData['products']) > 1 && count($products) > 0))) : ?>
        <div class="product-group <?php echo $type ?>-view">
            <h3 class="product-group-title mb-5"><?php echo vmText::_('COM_VIRTUEMART_' . strtoupper($type) . '_PRODUCT'); ?></h3>
    <?php endif; ?>

    <?php if ($params->get('products_mouseover_image_change', 1) && VmConfig::get('prodimg_browse', 1) < 2) : ?>
        <?php $productModel->addImages($products, 2); ?>
    <?php endif; ?>

    <?php foreach ($products as $product) : ?>
        <?php if (!is_object($product) || empty($product->link)) : ?>
            <?php vmdebug('$product is not object or link empty', $product); ?>
            <?php continue; ?>
        <?php endif; ?>
        
        <?php $productLink = Route::_(VirtuemartHelper::getProductUrl($product)); ?>

        <div class="product product-list-view product-slim d-flex">
            <div class="product-container w-100 d-flex flex-column align-self-start<?php $dynamic ? ' state-hover' : ''; ?>" data-vm="product-container">
                <div class="row">
                    <div class="col-4 col-md-3">
                        <div class="product-list-images">
                            <div class="product-image-default">
                                <a href="<?php echo $productLink; ?>">
                                    <?php echo VirtuemartHelper::prepareLazyImageHTML($product->images[0]->displayMediaThumb(['class' => $imageClass], false), $lazyLoad); ?>
                                </a>
                            </div>
                            <?php if ($params->get('products_mouseover_image_change', 1) && !empty($product->images[1])) : ?>
                                <div class="product-image-hover">
                                    <a href="<?php echo $productLink; ?>">
                                        <?php echo VirtuemartHelper::prepareLazyImageHTML($product->images[1]->displayMediaThumb(['class' => $imageClass], false), $lazyLoad); ?>
                                    </a>
                                </div>
                            <?php endif; ?>
                            <?php echo shopFunctionsF::renderVmSubLayout('productlabels', ['product' => $product]); ?>
                            <?php echo shopFunctionsF::renderVmSubLayout('utilities', ['product' => $product]); ?>
                        </div>
                    </div>
                    <div class="col-8 col-md-9">
                        <h3 class="product-name m-0 mb-2">
                            <a href="<?php echo $productLink; ?>"><?php echo $product->product_name; ?></a>
                        </h3>
                        <?php if ($params->get('products_show_categories', 1) && !empty($product->categories)) : ?>
                            <?php $categoryNames = VirtuemartHelper::getCategoryNames($product->categories); ?>
                            <div class="product-categories text-muted mb-2">
                                <?php echo implode(', ', $categoryNames); ?>
                            </div>
                        <?php endif; ?>
                        <?php if ($showRating && !empty($product->rating)) : ?>
                            <div class="product-rating mb-2">
                                <?php echo shopFunctionsF::renderVmSubLayout('rating', ['showRating' => $showRating, 'product' => $product, 'readonly' => true, 'showCount' => false, 'showReviews' => false]); ?>
                            </div>
                        <?php endif; ?>
                        <?php if ($showPrice) : ?>
                            <div class="product-prices mb-3">
                                <?php echo shopFunctionsF::renderVmSubLayout('prices', ['product' => $product, 'currency' => $currency, 'showDetails' => $params->get('products_show_all_prices', 0)]); ?>
                            </div>
                        <?php endif; ?>
                        <?php if (!empty($product->product_s_desc)) : ?>
                            <?php if ($product->product_s_desc != strip_tags($product->product_s_desc)) : ?>
                                <div class="product-short-description d-none d-md-block mb-3">
                                    <?php echo $product->product_s_desc; ?>
                                </div>
                            <?php else : ?>
                                <p class="product-short-description d-none d-md-block mb-3">
                                    <?php echo nl2br($product->product_s_desc); ?>
                                </p>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; ?>


    <?php if (!$dynamic && ((!empty($type) && count($products) > 0) || (count($viewData['products']) > 1 && count($products) > 0))) : ?>
        </div>
    <?php endif; ?>
<?php endforeach; ?>
