<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
**/

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Virtueplanet\Plugin\System\Prime\Helper\VirtuemartHelper;

defined('_JEXEC') or die;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app                = Factory::getApplication();
$currency           = $viewData['currency'];
$cellWidth          = [];
$template           = $app->getTemplate(true);
$params             = $template->params;
$showRating         = isset($viewData['showRating']) ? $viewData['showRating'] : true;
$showRating         = $showRating && $params->get('products_show_rating', 1);
$showPrice          = isset($viewData['showPrice']) ? $viewData['showPrice'] : true;
$isWishlist         = isset($viewData['isWishlist']) ? $viewData['isWishlist'] : false;
$removeFromWishlist = isset($viewData['removeFromWishlist']) ? $viewData['removeFromWishlist'] : false;
$showAddToCart      = isset($viewData['showAddToCart']) ? $viewData['showAddToCart'] : $params->get('products_show_addtocart', 1);
$products_per_row   = empty($viewData['products_per_row']) ? 1 : $viewData['products_per_row'];
$per_row_lg         = $params->get('products_per_row_lg', '');
$products_per_row   = $per_row_lg ? $per_row_lg : $products_per_row;
$cellWidth[]        = 'col-lg-' . floor(12 / $products_per_row);
$per_row_md         = $params->get('products_per_row_md', 3);
$cellWidth[]        = 'col-md-' . floor(12 / $per_row_md);
$per_row_sm         = $params->get('products_per_row_sm', 2);
$cellWidth[]        = 'col-sm-' . floor(12 / $per_row_sm);
$per_row_xs         = $params->get('products_per_row_xs', 2);
$cellWidth[]        = 'col-' . floor(12 / $per_row_xs);
$cellWidth          = implode(' ', array_reverse($cellWidth));
$productModel       = VmModel::getModel('product');
$dynamic            = false;
$lazyLoad           = $params->get('vm_image_lazyload', 1);
$imageClass         = $lazyLoad ? 'product-image lazy' : 'product-image';

if (vRequest::getInt('dynamic', 0) && vRequest::getInt('virtuemart_product_id', 0)) {
    $dynamic = true;
}
?>
<?php foreach ($viewData['products'] as $type => $products) : ?>
    <?php if (!$dynamic && ((!empty($type) && count($products) > 0) || (count($viewData['products']) > 1 && count($products) > 0))) : ?>
        <div class="product-group <?php echo $type ?>-view">
            <h3 class="product-group-title mb-5"><?php echo vmText::_('COM_VIRTUEMART_' . strtoupper($type) . '_PRODUCT'); ?></h3>
    <?php endif; ?>

    <?php if ($params->get('products_mouseover_image_change', 1) && VmConfig::get('prodimg_browse', 1) < 2) : ?>
        <?php $productModel->addImages($products, 2); ?>
    <?php endif; ?>

    <div class="row">
        <?php foreach ($products as $product) : ?>
            <?php if (!is_object($product) || empty($product->link)) : ?>
                <?php vmdebug('$product is not object or link empty', $product); ?>
                <?php continue; ?>
            <?php endif; ?>
            
            <?php $productLink = Route::_(VirtuemartHelper::getProductUrl($product)); ?>

            <div class="product product-grid-view <?php echo $cellWidth; ?>">
                <div class="product-container add-hover-effect w-100 d-flex flex-column align-self-start mb-4<?php $dynamic ? ' state-hover' : ''; ?>" data-vm="product-container">
                    <div class="product-top-container">
                        <?php if ($removeFromWishlist) : ?>
                            <div class="product-remove-from-wishlist mb-3">
                                <?php echo shopFunctionsF::renderVmSubLayout('removefromwishlist', ['product' => $product]); ?>
                            </div>
                        <?php endif; ?>
                        <div class="product-list-images mb-3 text-center">
                            <div class="product-image-default">
                                <a href="<?php echo $productLink; ?>">
                                    <?php echo VirtuemartHelper::prepareLazyImageHTML($product->images[0]->displayMediaThumb(['class' => $imageClass], false), $lazyLoad); ?>
                                </a>
                            </div>
                            <?php if ($params->get('products_mouseover_image_change', 1) && !empty($product->images[1])) : ?>
                                <div class="product-image-hover">
                                    <a href="<?php echo $productLink; ?>">
                                        <?php echo VirtuemartHelper::prepareLazyImageHTML($product->images[1]->displayMediaThumb(['class' => $imageClass], false), $lazyLoad); ?>
                                    </a>
                                </div>
                            <?php endif; ?>
                            <?php echo shopFunctionsF::renderVmSubLayout('productlabels', ['product' => $product]); ?>
                            <?php echo shopFunctionsF::renderVmSubLayout('utilities', ['product' => $product, 'isWishlist' => $isWishlist]); ?>
                        </div>
                        <h3 class="product-name text-center m-0 mb-2">
                            <a href="<?php echo $productLink; ?>"><?php echo $product->product_name; ?></a>
                        </h3>
                        <?php if ($params->get('products_show_categories', 1) && !empty($product->categories)) : ?>
                            <?php $categoryNames = VirtuemartHelper::getCategoryNames($product->categories); ?>
                            <div class="product-categories text-center text-muted mb-2">
                                <?php echo implode(', ', $categoryNames); ?>
                            </div>
                        <?php endif; ?>
                        <?php if ($showRating && !empty($product->rating)) : ?>
                            <div class="product-rating text-center mb-2">
                                <?php echo shopFunctionsF::renderVmSubLayout('rating', ['showRating' => $showRating, 'product' => $product, 'readonly' => true, 'showCount' => false, 'showReviews' => false]); ?>
                            </div>
                        <?php endif; ?>
                        <?php if ($showPrice) : ?>
                            <div class="product-prices text-center mb-3">
                                <?php echo shopFunctionsF::renderVmSubLayout('prices', ['product' => $product, 'currency' => $currency, 'showDetails' => $params->get('products_show_all_prices', 0)]); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    <?php if (($params->get('products_grid_show_short_desc', 1) && !empty($product->product_s_desc)) || $showAddToCart) : ?>
                        <div class="product-bottom-container pb-4">
                            <?php if ($params->get('products_grid_show_short_desc', 1) && !empty($product->product_s_desc)) : ?>
                                <?php if ($product->product_s_desc != strip_tags($product->product_s_desc)) : ?>
                                    <div class="product-short-description text-center mb-3">
                                        <?php echo $product->product_s_desc; ?>
                                    </div>
                                <?php else : ?>
                                    <p class="product-short-description text-center mb-3">
                                        <?php echo nl2br($product->product_s_desc); ?>
                                    </p>
                                <?php endif; ?>
                            <?php endif; ?>
                            <?php if ($showAddToCart) : ?>
                                <?php echo shopFunctionsF::renderVmSubLayout('addtocart', ['product' => $product, 'isList' => true, 'listMode' => 'grid']); ?>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                    <div class="product-backdrop" aria-hidden="true" tabindex="-1"></div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>

    <?php if (!$dynamic && ((!empty($type) && count($products) > 0) || (count($viewData['products']) > 1 && count($products) > 0))) : ?>
        </div>
    <?php endif; ?>
<?php endforeach; ?>
