<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
**/

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\Utilities\ArrayHelper;

defined('_JEXEC') or die;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app           = Factory::getApplication();
$template      = $app->getTemplate(true);
$productModel  = VmModel::getModel('product');
$params        = $template->params;
$product       = $viewData['product'];
$currency      = isset($viewData['currency']) ? $viewData['currency'] : CurrencyDisplay::getInstance();
$stockHandle   = VmConfig::get('stockhandle_products', false) && $product->product_stockhandle ? $product->product_stockhandle : VmConfig::get('stockhandle', 'none');
$discount      = $product->prices['discountAmount'] ? round($product->prices['discountAmount'], $currency->_priceConfig['salesPrice'][1]) : 0;
$newForDays    = (int) $params->get('new_label_days', 10);
$newUntilDate  = Factory::getDate('now - ' . $newForDays . ' days');
$availableDate = !empty($product->product_available_date) ? Factory::getDate($product->product_available_date) : null;
$currentDate   = Factory::getDate();
$labels          = [];

// Prepare new label
if ($params->get('show_new_label', 1) && $availableDate && $availableDate->toUnix() > 0 && $availableDate <= $currentDate && $availableDate >= $newUntilDate) {
    $attribs = [
        'class' => 'product-label product-label-new',
        'style' => '--product-label-bg: ' . $params->get('new_label_bg', '#438E44') . '; --product-label-color: ' . $params->get('new_label_color', '#ffffff') . ';'
    ];

    $labels[] = '<span ' . ArrayHelper::toString($attribs) . '>' . Text::_($params->get('new_label_text', 'New')) . '</span>';
}

// Prepare sold label
if ($params->get('show_sold_label', 0)) {
    if ($stockHandle == 'none') {
        $inStock = 1;
    } elseif ($stockHandle == 'disableit_children' && $product->product_parent_id == 0) {
        $children = $productModel->getProductChilds($product->virtuemart_product_id);
        $inStock  = $product->product_in_stock - $product->product_ordered;

        foreach ($children as $child) {
            $inStock += $child->product_in_stock - $child->product_ordered;
        }
    } else {
        $inStock = $product->product_in_stock - $product->product_ordered;
    }

    if ($inStock < 1) {
        $attribs = [
            'class' => 'product-label product-label-sold',
            'style' => '--product-label-bg: ' . $params->get('sold_label_bg', '#f0ad4e') . '; --product-label-color: ' . $params->get('sold_label_color', '#ffffff') . ';'
        ];

        $labels[] = '<span ' . ArrayHelper::toString($attribs) . '>' . Text::_($params->get('sold_label_text', 'Sold')) . '</span>';
    }
}

// Prepare discontinued label
if ($params->get('show_discontinued_label', 1) && $product->product_discontinued) {
    $attribs = [
        'class' => 'product-label product-label-discontinued',
        'style' => '--product-label-bg: ' . $params->get('discontinued_label_bg', '#d9534f') . '; --product-label-color: ' . $params->get('discontinued_label_color', '#ffffff') . ';'
    ];

    $labels[] = '<span ' . ArrayHelper::toString($attribs) . '>' . Text::_($params->get('discontinued_label_text', 'Discontinued')) . '</span>';
}

// Prepare sale label
if ($params->get('show_sale_label', 1) && !empty($discount)) {
    $attribs = [
        'class' => 'product-label product-label-sale',
        'style' => '--product-label-bg: ' . $params->get('sale_label_bg', '#337ab7') . '; --product-label-color: ' . $params->get('sale_label_color', '#ffffff') . ';'
    ];

    $labels[] = '<span ' . ArrayHelper::toString($attribs) . '>' . Text::_($params->get('sale_label_text', 'Sale')) . '</span>';
}

// Prepare featured label
if ($params->get('show_featured_label', 1) && $product->product_special) {
    $attribs = [
        'class' => 'product-label product-label-featured',
        'style' => '--product-label-bg: ' . $params->get('featured_label_bg', '#E22D2D') . '; --product-label-color: ' . $params->get('featured_label_color', '#ffffff') . ';'
    ];

    $labels[] = '<span ' . ArrayHelper::toString($attribs) . '>' . Text::_($params->get('featured_label_text', 'Hot')) . '</span>';
}

?>
<?php if (!empty($labels)) : ?>
    <div class="product-labels">
        <?php echo implode('', $labels); ?>
    </div>
<?php endif; ?>