<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;

defined('_JEXEC') or die;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app            = Factory::getApplication();
$template       = $app->getTemplate(true);
$params         = $template->params;
$product        = $viewData['product'];
$showDetails    = isset($viewData['showDetails']) ? $viewData['showDetails'] : false;
$currency       = $viewData['currency'];
$priceType      = isset($viewData['displayedPriceType']) ? $viewData['displayedPriceType'] : $params->get('displayed_price_type', 'salesPrice');
$priceType      = isset($product->prices[$priceType]) ? $priceType : 'salesPrice';
$unitPriceDesc  = vmText::sprintf('COM_VIRTUEMART_PRODUCT_UNITPRICE', vmText::_('COM_VIRTUEMART_UNIT_SYMBOL_' . $product->product_unit));
$priceDesc      = $priceType == 'unitPrice' ? $unitPriceDesc : '';
$stockhandle    = VmConfig::get('stockhandle_products', false) && property_exists($product, 'product_stockhandle') && $product->product_stockhandle ? $product->product_stockhandle : VmConfig::get('stockhandle', 'none');
$discount       = !empty($product->prices['discountAmount']) ? round($product->prices['discountAmount'], $currency->_priceConfig['salesPrice'][1]) : 0;
$infotax        = vmConfig::get('vm_prices_info_tax', 0);
$infodelivery   = vmConfig::get('vm_prices_info_delivery', 0);

if ($product->prices['priceWithoutTax'] === $product->prices['salesPrice']) {
    $taxclusive = 'COM_VM_TAX_EXCLUSIVE';
} else {
    $taxclusive = 'COM_VM_TAX_INCLUSIVE';
}
?>
<?php if (!$product->product_discontinued || $params->get('vm_handle_discontinued_products', 0) < 2) : ?>
    <div class="product-price" id="productPrice<?php echo $product->virtuemart_product_id ?>" data-vm="product-prices">
        <?php if ($product->prices['salesPrice'] <= 0 && VmConfig::get('askprice', 1) && isset($product->images[0]) && !$product->images[0]->file_is_downloadable) : ?>
            <?php $url = Route::_('index.php?option=com_virtuemart&view=productdetails&task=askquestion&virtuemart_product_id=' . $product->virtuemart_product_id . '&virtuemart_category_id=' . $product->virtuemart_category_id . '&tmpl=component', false); ?>
            <a class="btn btn-primary btn-md btn-ask-price" href="<?php echo $url; ?>" rel="nofollow" data-glightbox-link="true"><?php echo vmText::_('COM_VIRTUEMART_PRODUCT_ASKPRICE'); ?></a>
        <?php else : ?>
            <?php if ($priceType != 'basePriceWithTax' && $priceType != 'salesPriceWithDiscount') : ?>
                <?php if (!empty($discount) && VmConfig::get('basePriceWithTax', 0) && !empty($product->prices['basePriceWithTax']) && round($product->prices['basePriceWithTax'], $currency->_priceConfig['salesPrice'][1]) != $product->prices['salesPrice']) : ?>
                    <div class="product-price-before-discount">
                        <?php echo $currency->createPriceDiv('basePriceWithTax', '', $product->prices); ?>
                    </div>
                <?php elseif (!empty($discount) && VmConfig::get('salesPriceWithDiscount', 0) && !empty($product->prices['salesPriceWithDiscount']) && round($product->prices['salesPriceWithDiscount'], $currency->_priceConfig['salesPrice'][1]) != $product->prices['salesPrice']) : ?>
                    <div class="product-price-before-discount">
                        <?php echo $currency->createPriceDiv('salesPriceWithDiscount', '', $product->prices); ?>
                    </div>
                <?php endif; ?>
            <?php elseif (!empty($discount) && $priceType == 'basePriceWithTax' && VmConfig::get('salesPriceWithDiscount', 0) && !empty($product->prices['salesPriceWithDiscount']) && round($product->prices['salesPriceWithDiscount'], $currency->_priceConfig['salesPrice'][1]) != $product->prices['salesPrice']) : ?>
                <div class="product-price-before-discount">
                    <?php echo $currency->createPriceDiv('salesPriceWithDiscount', '', $product->prices); ?>
                </div>
            <?php endif; ?>
            <div class="product-sales-price">
                <?php echo $currency->createPriceDiv($priceType, $priceDesc, $product->prices); ?>
            </div>
            <?php if (($infotax || $infodelivery) && !empty($product->prices['salesPrice'])) : ?>
                <div class="vm-prices-info text-muted">
                    <?php if ($infotax) : ?>
                        <?php echo vmText::_($taxclusive); ?>
                    <?php endif; ?>
                    <?php if ($infotax && $infodelivery) : ?>
                        <?php echo vmText::_('COM_VM_PRICES_INFO_DIVIDER'); ?>
                    <?php endif; ?>
                    <?php if ($infodelivery) : ?>
                        <?php echo vmText::_('COM_VM_PRICES_INFO_DELIVERY'); ?>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            <?php if ($priceType != 'discountAmount' && VmConfig::get('discountAmount', 0) && !empty($discount)) : ?>
                <div class="product-discount-amount">
                    <?php $discount = ($product->prices['discountAmount'] < 0) ? ($product->prices['discountAmount'] * -1) : $product->prices['discountAmount']; ?>
                    <?php echo vmText::_('TPL_VP_NEOTERIC_YOU_SAVE') . ': ' . $currency->createPriceDiv('discountAmount', '', $discount); ?>
                </div>
            <?php endif; ?>
            <?php if ($showDetails) : ?>
                <div class="product-all-prices text-muted">
                    <?php echo $currency->createPriceDiv('basePrice', 'COM_VIRTUEMART_PRODUCT_BASEPRICE', $product->prices); ?>
                    <?php echo $currency->createPriceDiv('basePriceVariant', 'COM_VIRTUEMART_PRODUCT_BASEPRICE_VARIANT', $product->prices); ?>
                    <?php echo $currency->createPriceDiv('variantModification', 'COM_VIRTUEMART_PRODUCT_VARIANT_MOD', $product->prices); ?>

                    <?php if (round($product->prices['basePriceWithTax'], $currency->_priceConfig['salesPrice'][1]) != round($product->prices['salesPrice'], $currency->_priceConfig['salesPrice'][1])) : ?>
                        <?php echo '<span class="price-crossed" >' . $currency->createPriceDiv('basePriceWithTax', 'COM_VIRTUEMART_PRODUCT_BASEPRICE_WITHTAX', $product->prices) . '</span>'; ?>
                    <?php endif; ?>

                    <?php if (round($product->prices['salesPriceWithDiscount'], $currency->_priceConfig['salesPrice'][1]) != round($product->prices['salesPrice'], $currency->_priceConfig['salesPrice'][1])) : ?>
                        <?php echo $currency->createPriceDiv('salesPriceWithDiscount', 'COM_VIRTUEMART_PRODUCT_SALESPRICE_WITH_DISCOUNT', $product->prices); ?>
                    <?php endif; ?>

                    <?php echo $currency->createPriceDiv('salesPrice', 'COM_VIRTUEMART_PRODUCT_SALESPRICE', $product->prices); ?>
                    <?php echo $currency->createPriceDiv('salesPriceTt', 'COM_VIRTUEMART_PRODUCT_SALESPRICE_TT', $product->prices); ?>

                    <?php if ($product->prices['discountedPriceWithoutTax'] != $product->prices['priceWithoutTax']) : ?>
                        <?php echo $currency->createPriceDiv('discountedPriceWithoutTax', 'COM_VIRTUEMART_PRODUCT_SALESPRICE_WITHOUT_TAX', $product->prices); ?>
                        <?php echo $currency->createPriceDiv('discountedPriceWithoutTaxTt', 'COM_VIRTUEMART_PRODUCT_SALESPRICE_WITHOUT_TAX_TT', $product->prices); ?>
                    <?php else : ?>
                        <?php echo $currency->createPriceDiv('priceWithoutTax', 'COM_VIRTUEMART_PRODUCT_SALESPRICE_WITHOUT_TAX', $product->prices); ?>
                        <?php echo $currency->createPriceDiv('priceWithoutTaxTt', 'COM_VIRTUEMART_PRODUCT_SALESPRICE_WITHOUT_TAX_TT', $product->prices); ?>
                    <?php endif; ?>

                    <?php echo $currency->createPriceDiv('discountAmount', 'COM_VIRTUEMART_PRODUCT_DISCOUNT_AMOUNT', $product->prices); ?>
                    <?php echo $currency->createPriceDiv('discountAmountTt', 'COM_VIRTUEMART_PRODUCT_DISCOUNT_AMOUNT_TT', $product->prices); ?>
                    <?php echo $currency->createPriceDiv('taxAmount', 'COM_VIRTUEMART_PRODUCT_TAX_AMOUNT', $product->prices); ?>
                    <?php echo $currency->createPriceDiv('taxAmountTt', 'COM_VIRTUEMART_PRODUCT_TAX_AMOUNT_TT', $product->prices); ?>
                    <?php echo $currency->createPriceDiv('unitPrice', $unitPriceDesc, $product->prices); ?>
                </div>
            <?php endif; ?>
        <?php endif; ?>
    </div>
<?php endif; ?>