<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Router\Route;

$manufacturers   = $viewData['manufacturers'];
$fieldLink       = $viewData['fieldLink'];
$orderbyTxt      = $viewData['orderbyTxt'];
$orderDirLink    = $viewData['orderDirLink'];
$manufacturerId  = vRequest::getInt('virtuemart_manufacturer_id', 0);
$manufacturerVar = !empty($manufacturerId) ? '&virtuemart_manufacturer_id=' . $manufacturerId : '';
$cleanLink       = $manufacturerId > 0 ? str_replace($manufacturerVar, '', $fieldLink) : $fieldLink;
$allUrl          = Route::_($cleanLink . '&virtuemart_manufacturer_id=0' . $orderbyTxt . $orderDirLink . '&limitstart=0');
$options         = [];
$activeOption    = null;

if (!empty($manufacturers)) {
    $options[] = HTMLHelper::_('select.option', $allUrl, vmText::_('COM_VIRTUEMART_SEARCH_SELECT_ALL_MANUFACTURER'));

    foreach ($manufacturers as $manufacturer) {
        $url = Route::_($cleanLink . '&virtuemart_manufacturer_id=' . $manufacturer->virtuemart_manufacturer_id . $orderbyTxt . $orderDirLink . '&limitstart=0');

        $options[] = HTMLHelper::_('select.option', $url, $manufacturer->mf_name);

        if ($manufacturer->virtuemart_manufacturer_id == $manufacturerId) {
            $activeOption = $url;
        }
    }

    $attribs          = 'onchange="document.location.replace(this.value);"';
    $attribs         .= ' class="form-select normal-choice"';
    $manufacturerList = HTMLHelper::_('select.genericlist', $options, 'vm-manufacturer-filter', $attribs, 'value', 'text', $activeOption, 'vm-manufacturer-filter');

    // Build the final HTML output.
    $html  = '<div class="row gx-2 align-items-center">';
    $html .= '<div class="col-auto">';
    $html .= '<label for="vm-manufacturer-filter" class="col-form-label">' . vmText::_('COM_VIRTUEMART_PRODUCT_DETAILS_MANUFACTURER_LBL') . '</label>';
    $html .= '</div>';
    $html .= '<div class="col-auto">';
    $html .= $manufacturerList;
    $html .= '</div>';
    $html .= '</div>';

    echo $html;
}
