<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Router\Route;

defined('_JEXEC') or die;

$orderby         = $viewData['orderby'];
$fieldLink       = $viewData['fieldLink'];
$orderDir        = $viewData['orderDir'];
$orderbyTxt      = $viewData['orderbyTxt'];
$orderDirLink    = $viewData['orderDirLink'];
$fields          = (array) VmConfig::get('browse_orderby_fields', []);
$defaultOrderDir = (string) VmConfig::get('prd_brws_orderby_dir');
$defaultOrderby  = (string) VmConfig::get('browse_orderby_field');
$manufacturerId  = vRequest::getInt('virtuemart_manufacturer_id', 0);
$manufacturerVar = '';
$options         = [];
$activeOption    = null;

if (!empty($manufacturerId)) {
    $manufacturerVar = '&virtuemart_manufacturer_id=' . $manufacturerId;
}

if (count($fields) > 1) {
    foreach ($fields as $field) {
        $oField = $field;
        $dotPos = strrpos($field, '.');

        if ($dotPos !== false) {
            $prefix             = substr($field, 0, $dotPos + 1);
            $fieldWithoutPrefix = substr($field, $dotPos + 1);
        } else {
            $prefix             = '';
            $fieldWithoutPrefix = $field;
        }

        $text = vmText::_('COM_VIRTUEMART_' . strtoupper(str_replace([',', ' '], ['_', ''], $fieldWithoutPrefix)));

        if ($dotPos !== false) {
            $parts = explode('.', $field);

            if (isset($parts[1])) {
                $field = $parts[1];
            } else {
                $field = $parts[0];
            }
        }

        $value = Route::_($fieldLink . $manufacturerVar . '&orderby=' . $field);

        if ($oField == $orderby || $field == $orderby) {
            $activeOption = $value;
        }

        $options[] = HTMLHelper::_('select.option', $value, $text);
    }

    if (empty($orderby)) {
        $orderby = $defaultOrderby;
    }

    if (!$activeOption && !in_array($orderby, $fields)) {
        $dotPos  = strrpos($orderby, '.');
        $prefix  = '';

        if ($dotPos !== false) {
            $prefix  = substr($orderby, 0, $dotPos + 1);
            $orderby = substr($orderby, $dotPos + 1);
        }

        $text          = vmText::_('COM_VIRTUEMART_SEARCH_ORDER_' . strtoupper(str_replace([',', ' '], ['_', ''], $orderby)));
        $defaultOption = HTMLHelper::_('select.option', '', $text);

        array_unshift($options, $defaultOption);
    }

    $attribs      = 'onchange="document.location.replace(this.value);"';
    $attribs     .= ' class="form-select normal-choice"';
    $orderByList  = HTMLHelper::_('select.genericlist', $options, 'vm-orderby', $attribs, 'value', 'text', $activeOption, 'vm-orderby');
    $newOrderDir  = strtoupper($orderDir) === 'ASC' ? 'DESC' : 'ASC';
    $orderDirVar  = $newOrderDir !== $defaultOrderDir ? '&dir=' . $newOrderDir : '';
    $orderDirText = vmText::_('COM_VIRTUEMART_' . $newOrderDir);
    $orderDirUrl  = Route::_($fieldLink . $manufacturerVar . $orderbyTxt . $orderDirVar);
    $dirIconClass = $newOrderDir === 'ASC' ? 'fas fa-long-arrow-alt-down' : 'fas fa-long-arrow-alt-up';

    // Build the final HTML output.
    $html  = '<div class="row gx-2 align-items-center">';
    $html .= '<div class="col-auto">';
    $html .= '<label for="vm-orderby" class="col-form-label">' . vmText::_('COM_VIRTUEMART_ORDERBY') . '</label>';
    $html .= '</div>';
    $html .= '<div class="col-auto">';
    $html .= $orderByList;
    $html .= '</div>';
    $html .= '<div class="col-auto">';
    $html .= '<a href="' . $orderDirUrl . '" class="btn btn-switch btn-secondary" title="' . $orderDirText . '">';
    $html .= '<span class="visually-hidden">' . $orderDirText . '</span>';
    $html .= '<i class="' . $dirIconClass . '" aria-hidden="true"></i>';
    $html .= '</a>';
    $html .= '</div>';
    $html .= '</div>';

    echo $html;
}
