<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Helper\AuthenticationHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

defined('_JEXEC') or die;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app          = Factory::getApplication();
$user         = Factory::getUser();
$show         = !isset($this) || !property_exists($this, 'show') ? true : $this->show;
$fromCart     = !isset($this) || !property_exists($this, 'from_cart') ? true : $this->from_cart;
$order        = !isset($this) || !property_exists($this, 'order') ? true : $this->order;
$url          = !isset($this) || !property_exists($this, 'url') || empty($this->url) ? vmURI::getCurrentUrlBy('request') : $this->url;
$input        = $app->input;
$option       = strtolower($input->getCmd('option', ''));
$view         = strtolower($input->getCmd('view', ''));
$isCartPage   = ($option == 'com_virtuemart' && in_array($view, ['cart', 'pluginresponse', 'vmplg']));
$formId       = 'vm-login-form';
$extraButtons = AuthenticationHelper::getLoginButtons($formId);
$paymentHtml  = '';

$app->getDocument()->getWebAssetManager()
    ->useScript('core')
    ->useScript('keepalive')
    ->useScript('field.passwordview')
    ->useScript('bootstrap.collapse');

Text::script('JSHOWPASSWORD');
Text::script('JHIDEPASSWORD');

if (isset($this)) {
    vDispatcher::importVMPlugins('vmpayment');
    vDispatcher::trigger('plgVmDisplayLogin', array($this, &$paymentHtml, $fromCart));

    if (is_array($paymentHtml)) {
        $paymentHtml = '<div class="mb-2">' . implode('</div><div class="mb-2">', $paymentHtml) . '</div>';
    } elseif (!empty($paymentHtml)) {
        $paymentHtml = '<div class="mb-2">' . $paymentHtml . '</div>';
    }
}

if ($show && $user->guest) {
    vmJsApi::vmValidator();
}
?>
<div class="vm-login-sublayout">
    <?php if ($show && $user->guest) : ?>
        <?php echo $paymentHtml; ?>

        <?php if ($order) : ?>
            <div class="order-login-container mb-5">
                <h2 class="sub-heading text-md-center"><?php echo vmText::_('COM_VIRTUEMART_ORDER_ANONYMOUS'); ?></h2>

                <form action="<?php echo Route::_('index.php', true); ?>" method="post" class="form-validate">
                    <div class="row g-2">
                        <div class="col-md-6 mb-3">
                            <label for="order_number" class="form-label"><?php echo vmText::_('COM_VIRTUEMART_ORDER_NUMBER') ?></label>
                            <input type="text" id="order_number" name="order_number" class="form-control required" required />
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="order_pass" class="form-label"><?php echo vmText::_('COM_VIRTUEMART_ORDER_PASS') ?></label>
                            <input type="text" id="order_pass" name="order_pass" class="form-control required" required />
                        </div>
                        <div class="col-md-12 mb-3">
                            <div class="row justify-content-center">
                                <div class="col-md-6">
                                <button type="submit" class="btn btn-primary validate w-100"><?php echo vmText::_('COM_VIRTUEMART_ORDER_BUTTON_VIEW'); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <input type="hidden" name="option" value="com_virtuemart" />
                    <input type="hidden" name="view" value="orders" />
                    <input type="hidden" name="layout" value="details" />
                    <input type="hidden" name="return" value="" />
                </form>
            </div>
        <?php endif; ?>
        
        <div class="vm-login-container<?php echo $isCartPage ? '' : ' mb-5'; ?>">
            <?php if ($order) : ?>
                <h2 class="sub-heading text-md-center"><?php echo vmText::_('COM_VIRTUEMART_ORDER_CONNECT_FORM'); ?></h2>
            <?php elseif ($isCartPage) : ?>
                <p class="mb-4">
                    <?php echo vmText::_('COM_VIRTUEMART_ORDER_CONNECT_FORM'); ?><br/>
                    <a class="btn btn-secondary btn-sm w-100 mt-3" href="#cartLoginSection" data-bs-toggle="collapse" aria-expanded="false" aria-controls="cartLoginSection">
                        <?php echo vmText::_('JLOGIN'); ?>
                    </a>
                </p>
            <?php else : ?>
                <p><?php echo vmText::_('COM_VIRTUEMART_ORDER_CONNECT_FORM'); ?></p>
            <?php endif; ?>

            <?php if ($order) : ?>
                <form id="<?php echo $formId; ?>" action="<?php echo Uri::root(true) . '/' . $url; ?>" method="post">
                    <div class="row g-2">
                        <div class="col-md-6 mb-3">
                            <label for="vm-login-username" class="form-label"><?php echo vmText::_('COM_VIRTUEMART_USERNAME'); ?></label>
                            <input type="text" id="vm-login-username" name="username" class="form-control" value="" />
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="vm-login-password" class="form-label"><?php echo vmText::_('COM_VIRTUEMART_PASSWORD'); ?></label>
                            <div class="input-group">
                                <input id="vm-login-password" type="password" name="password" autocomplete="current-password" class="form-control" value="" />
                                <button type="button" class="btn btn-secondary input-password-toggle">
                                    <span class="icon-eye icon-fw" aria-hidden="true"></span>
                                    <span class="visually-hidden"><?php echo Text::_('JSHOWPASSWORD'); ?></span>
                                </button>
                            </div>
                        </div>

                        <?php if (PluginHelper::isEnabled('system', 'remember')) : ?>
                            <div class="col-md-12 mb-2">
                                <div class="d-flex justify-content-md-center">
                                    <div class="form-check">
                                        <input type="checkbox" name="remember" class="form-check-input" value="yes" id="vm-login-remember" />
                                        <label class="form-check-label" for="vm-login-remember">
                                            <?php echo vmText::_('JGLOBAL_REMEMBER_ME'); ?>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php foreach ($extraButtons as $button) :
                            $dataAttributeKeys = array_filter(array_keys($button), function ($key) {
                                return substr($key, 0, 5) == 'data-';
                            });
                            ?>
                            <div class="col-md-12 mb-3">
                                <div class="row justify-content-center">
                                    <div class="col-md-6">
                                        <button type="button"
                                                class="btn btn-secondary w-100 <?php echo $button['class'] ?? '' ?>"
                                                <?php foreach ($dataAttributeKeys as $key) : ?>
                                                    <?php echo $key ?>="<?php echo $button[$key] ?>"
                                                <?php endforeach; ?>
                                                <?php if ($button['onclick']) : ?>
                                                onclick="<?php echo $button['onclick'] ?>"
                                                <?php endif; ?>
                                                title="<?php echo vmText::_($button['label']) ?>"
                                                id="<?php echo $button['id'] ?>"
                                                >
                                            <?php if (!empty($button['icon'])) : ?>
                                                <span class="<?php echo $button['icon'] ?>"></span>
                                            <?php elseif (!empty($button['image'])) : ?>
                                                <?php echo $button['image']; ?>
                                            <?php elseif (!empty($button['svg'])) : ?>
                                                <?php echo $button['svg']; ?>
                                            <?php endif; ?>
                                            <?php echo vmText::_($button['label']) ?>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>

                        <div class="col-md-12 mb-3">
                            <div class="row justify-content-center">
                                <div class="col-md-6">
                                    <button type="submit" name="Submit" class="btn btn-primary w-100"><?php echo vmText::_('JLOGIN'); ?></button>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-12 mb-3">
                            <div class="d-flex justify-content-center">
                                <ul class="list-inline">
                                    <li class="list-inline-item"><a href="<?php echo Route::_('index.php?option=com_users&view=remind'); ?>" rel="nofollow"><?php echo vmText::_('COM_VIRTUEMART_ORDER_FORGOT_YOUR_USERNAME'); ?></a></li>
                                    <li class="list-inline-item"><a href="<?php echo Route::_('index.php?option=com_users&view=reset'); ?>" rel="nofollow"><?php echo vmText::_('COM_VIRTUEMART_ORDER_FORGOT_YOUR_PASSWORD'); ?></a></li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <input type="hidden" name="task" value="user.login" />
                    <input type="hidden" name="option" value="com_users" />
                    <input type="hidden" name="return" value="<?php echo base64_encode($url); ?>" />
                    <?php echo HTMLHelper::_('form.token'); ?>
                </form>
            <?php else : ?>
                <?php if ($isCartPage) : ?>
                    <div class="collapse" id="cartLoginSection">
                <?php endif; ?>

                <form id="<?php echo $formId; ?>" action="<?php echo Uri::root(true) . '/' . $url; ?>" method="post">
                    <div class="control-group">
                        <div class="control-label">
                            <label for="vm-login-username" class="form-label"><?php echo vmText::_('COM_VIRTUEMART_USERNAME'); ?></label>
                        </div>
                        <div class="controls">
                            <input type="text" id="vm-login-username" name="username" class="form-control" value="" />
                        </div>
                    </div>
                    <div class="control-group">
                        <div class="control-label">
                            <label for="vm-login-password" class="form-label"><?php echo vmText::_('COM_VIRTUEMART_PASSWORD'); ?></label>
                        </div>
                        <div class="controls">
                            <div class="input-group">
                                <input id="vm-login-password" type="password" name="password" autocomplete="current-password" class="form-control" value="" />
                                <button type="button" class="btn btn-secondary input-password-toggle">
                                    <span class="icon-eye icon-fw" aria-hidden="true"></span>
                                    <span class="visually-hidden"><?php echo Text::_('JSHOWPASSWORD'); ?></span>
                                </button>
                            </div>
                        </div>
                    </div>
                    <?php if (PluginHelper::isEnabled('system', 'remember')) : ?>
                        <div class="control-group">
                            <div class="controls">
                                <div class="form-check">
                                    <input type="checkbox" name="remember" class="form-check-input" value="yes" id="vm-login-remember" />
                                    <label class="form-check-label" for="vm-login-remember">
                                        <?php echo vmText::_('JGLOBAL_REMEMBER_ME'); ?>
                                    </label>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php foreach ($extraButtons as $button) :
                        $dataAttributeKeys = array_filter(array_keys($button), function ($key) {
                            return substr($key, 0, 5) == 'data-';
                        });
                        ?>
                        <div class="control-group">
                            <button type="button"
                                    class="btn btn-secondary w-100 <?php echo $button['class'] ?? '' ?>"
                                    <?php foreach ($dataAttributeKeys as $key) : ?>
                                        <?php echo $key ?>="<?php echo $button[$key] ?>"
                                    <?php endforeach; ?>
                                    <?php if ($button['onclick']) : ?>
                                    onclick="<?php echo $button['onclick'] ?>"
                                    <?php endif; ?>
                                    title="<?php echo vmText::_($button['label']) ?>"
                                    id="<?php echo $button['id'] ?>"
                                    >
                                <?php if (!empty($button['icon'])) : ?>
                                    <span class="<?php echo $button['icon'] ?>"></span>
                                <?php elseif (!empty($button['image'])) : ?>
                                    <?php echo $button['image']; ?>
                                <?php elseif (!empty($button['svg'])) : ?>
                                    <?php echo $button['svg']; ?>
                                <?php endif; ?>
                                <?php echo vmText::_($button['label']) ?>
                            </button>
                        </div>
                    <?php endforeach; ?>
                    <div class="control-group">
                        <button type="submit" name="Submit" class="btn btn-primary w-100"><?php echo vmText::_('JLOGIN'); ?></button>
                    </div>
                    <div class="control-group">
                        <ul class="list-inline">
                            <li class="list-inline-item"><a href="<?php echo Route::_('index.php?option=com_users&view=remind'); ?>" rel="nofollow"><?php echo vmText::_('COM_VIRTUEMART_ORDER_FORGOT_YOUR_USERNAME'); ?></a></li>
                            <li class="list-inline-item"><a href="<?php echo Route::_('index.php?option=com_users&view=reset'); ?>" rel="nofollow"><?php echo vmText::_('COM_VIRTUEMART_ORDER_FORGOT_YOUR_PASSWORD'); ?></a></li>
                        </ul>
                    </div>
                    <input type="hidden" name="task" value="user.login" />
                    <input type="hidden" name="option" value="com_users" />
                    <input type="hidden" name="return" value="<?php echo base64_encode($url); ?>" />
                    <?php echo HTMLHelper::_('form.token'); ?>
                </form>
                <div class="separator-line mb-5" aria-hidden="true"></div>

                <?php if ($isCartPage) : ?>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    <?php elseif (!$user->guest) : ?>
        <form action="<?php echo Uri::root(true) . '/' . $url; ?>" method="post" id="form-logout">
            <div class="d-flex align-items-center<?php echo $isCartPage ? ' justify-content-center' : ''; ?> mb-4">
                <div class="login-greeting me-2"><?php echo vmText::sprintf('COM_VIRTUEMART_HINAME', $user->name); ?></div>
                <button type="submit" class="btn btn-primary">
                    <?php echo vmText::_('COM_VIRTUEMART_BUTTON_LOGOUT'); ?>
                </button>
            </div>
            <input type="hidden" name="option" value="com_users" />
            <input type="hidden" name="task" value="user.logout" />
            <input type="hidden" name="return" value="<?php echo base64_encode($url) ?>" />
            <?php echo HTMLHelper::_('form.token'); ?>
        </form>
    <?php endif; ?>
</div>