<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

$product          = $viewData['product'];
$position         = $viewData['position'];
$customTitle      = isset($viewData['customTitle']) ? $viewData['customTitle'] : false;
$class            = isset($viewData['class']) ? $viewData['class'] : 'product-fields';
$customFieldTitle = null;
?>
<?php if (!empty($product->customfieldsSorted[$position])) : ?>
    <div class="<?php echo $class; ?>">
        <?php if ($customTitle && isset($product->customfieldsSorted[$position][0])) : ?>
            <?php $field = $product->customfieldsSorted[$position][0]; ?>
            <div class="product-fields-title-wrapper">
                <span class="product-fields-title"><?php echo vmText::_($field->custom_title); ?></span>
                <?php if ($field->custom_tip) : ?>
                    <span class="product-fields-tooltip has-popover" data-bs-content="<?php echo vmText::_($field->custom_tip); ?>" aria-hidden="true"><i class="fas fa-info-circle"></i></span>
                <?php endif; ?>
            </div> 
        <?php endif; ?>

    <?php foreach ($product->customfieldsSorted[$position] as $field) : ?>
        <?php if ($field->is_hidden || empty($field->display)) :
            continue;
        endif; ?>
        <div class="product-field product-field-type-<?php echo $field->field_type; ?>">
            <?php if (!$customTitle && $field->custom_title != $customFieldTitle && $field->show_title) : ?>
                <div class="product-fields-title-wrapper">
                    <span class="product-fields-title"><?php echo vmText::_($field->custom_title); ?></span>
                    <?php if ($field->custom_tip) : ?>
                        <span class="product-fields-tooltip has-popover" data-bs-content="<?php echo vmText::_($field->custom_tip); ?>" aria-hidden="true"><i class="fas fa-info-circle"></i></span>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            <?php if (!empty($field->display)) : ?>
                <div class="product-field-display"><?php echo $field->display; ?></div>
            <?php endif; ?>
            <?php if (!empty($field->custom_desc)) : ?>
                <div class="product-field-desc"><?php echo vmText::_($field->custom_desc); ?></div>
            <?php endif; ?>
        </div>
        <?php $customFieldTitle = $field->custom_title; ?>
    <?php endforeach; ?>
    </div>
<?php endif; ?>