<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

$activeStep = isset($viewData['activeStep']) ? $viewData['activeStep'] : 1;
$steps      = [];
$stepNames  = [
    'COM_VIRTUEMART_CART_TITLE',
    'TPL_VP_NEOTERIC_INFORMATION',
    'COM_VIRTUEMART_CART_EDIT_SHIPPING',
    'COM_VIRTUEMART_CART_EDIT_PAYMENT',
    'COM_VIRTUEMART_ORDER_CONFIRM_MNU'
];

for ($i = 1; $i <= 5; $i++) {
    $step = new stdClass();

    $step->title = $stepNames[$i - 1];
    $step->className = 'step-todo';

    if ($activeStep > $i) {
        $step->className = 'step-done';
    } elseif ($activeStep == $i) {
        $step->className = 'step-active';
    }

    $steps[] = $step;
}
?>
<ol class="steps-bar mb-5">
    <?php foreach ($steps as $step) : ?>
        <li class="<?php echo $step->className; ?>">
            <?php echo vmText::_($step->title); ?>
        </li>
    <?php endforeach; ?>
</ol>