<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Virtueplanet\Plugin\System\Prime\Helper\VirtuemartHelper;

defined('_JEXEC') or die;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app         = Factory::getApplication();
$template    = $app->getTemplate(true);
$params      = $template->params;
$cellWidth   = [];
$categories  = $viewData['categories'];
$itemsPerRow = !empty($viewData['categories_per_row']) ? $viewData['categories_per_row'] : VmConfig::get('categories_per_row', 3);
$perRowLg    = $params->get('items_per_row_lg', '');
$itemsPerRow = $perRowLg ? $perRowLg : $itemsPerRow;
$cellWidth[] = 'col-lg-' . floor(12 / $itemsPerRow);
$perRowMd    = $params->get('items_per_row_md', 3);
$cellWidth[] = 'col-md-' . floor(12 / $perRowMd);
$perRowSm    = $params->get('items_per_row_sm', 2);
$cellWidth[] = 'col-sm-' . floor(12 / $perRowSm);
$perRowXs    = $params->get('items_per_row_xs', 2);
$cellWidth[] = 'col-' . floor(12 / $perRowXs);
$cellWidth   = implode(' ', array_reverse($cellWidth));
$ajaxUpdate  = VmConfig::get('ajax_category', false) ? ' data-dynamic-update="1"' : '';
$lazyLoad    = $params->get('vm_image_lazyload', 1);
$imageClass  = $lazyLoad ? 'category-image lazy' : 'category-image';
?>
<?php if (!empty($categories)) : ?>
    <div class="virtuemart-categories mb-4">
        <div class="row">
            <?php foreach ($categories as $category) : ?>
                <?php $url = Route::_('index.php?option=com_virtuemart&view=category&virtuemart_category_id=' . $category->virtuemart_category_id); ?>
                <div class="category d-flex <?php echo $cellWidth; ?>">
                    <div class="item-container add-hover-effect w-100 d-flex flex-column mb-4">
                        <div class="category-image d-flex align-items-center justify-content-center mb-3">
                            <a href="<?php echo $url ?>"<?php echo $ajaxUpdate; ?>>
                                <?php echo VirtuemartHelper::prepareLazyImageHTML($category->images[0]->displayMediaThumb('class="' . $imageClass . '"', false), $lazyLoad); ?>
                            </a>
                        </div>
                        <h3 class="category-name text-center m-0 mb-3">
                            <a href="<?php echo $url ?>"<?php echo $ajaxUpdate; ?>><?php echo vmText::_($category->category_name); ?></a>
                        </h3>
                        <div class="item-backdrop" aria-hidden="true" tabindex="-1"></div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
<?php endif; ?>