<?php

/**
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;

defined('_JEXEC') or die;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app             = Factory::getApplication();
$template        = $app->getTemplate(true);
$params          = $template->params;
$product         = $viewData['product'];
$isList          = isset($viewData['isList']) ? $viewData['isList'] : false;
$listMode        = isset($viewData['listMode']) ? $viewData['listMode'] : 'grid';
$init            = isset($viewData['init']) ? $viewData['init'] : 1;
$step            = 1;
$maxOrder        = '';
$addtoCartButton = '';
$minOrderLevel   = $product->min_order_level > 0 ? $product->min_order_level : 1;
$stockhandle     = VmConfig::get('stockhandle_products', false) && $product->product_stockhandle ? $product->product_stockhandle : VmConfig::get('stockhandle', 'none');
$tmpPrice        = (float) $product->prices['costPrice'];
$quantityFieldId = 'quantity-' . $product->virtuemart_product_id . '-' . uniqid();
$qtyClassSuffix  = !$isList ? ' input-group-lg' : '';
$qtyClassSuffix .= $isList && !$params->get('products_show_quantity_selector', 0) ? ' d-none' : '';

if (!empty($product->min_order_level) && $init < $product->min_order_level) {
    $init = $product->min_order_level;
}

if (!empty($product->step_order_level)) {
    $step = $product->step_order_level;

    if (!empty($init)) {
        if ($init < $step) {
            $init = $step;
        } elseif ($init > $step) {
            $init = ceil($init / $step) * $step;
        }
    }

    if (empty($product->min_order_level) && !isset($viewData['init'])) {
        $init = $step;
    }
}

if (!empty($product->max_order_level)) {
    $maxOrder = 'max="' . $product->max_order_level . '"';
}

if (!$product->addToCartButton && $product->addToCartButton !== '') {
    $addtoCartButton = self::renderVmSubLayout('addtocartbtn', ['orderable' => $product->orderable, 'isList' => $isList, 'listMode' => $listMode]);
} else {
    $addtoCartButton = $product->addToCartButton;
}
?>
<?php if (!VmConfig::get('use_as_catalog', 0)) : ?>
    <div class="addtocart-bar d-flex flex-row flex-wrap gap-3 align-items-center <?php echo $isList && $listMode === 'grid' ? 'justify-content-center' : 'justify-content-start'; ?>">
        <?php if ($product->show_notify) : ?>
            <a class="btn btn-notify btn-info" href="<?php echo Route::_('index.php?option=com_virtuemart&view=productdetails&layout=notify&virtuemart_product_id=' . $product->virtuemart_product_id); ?>" target="_parent"><?php echo vmText::_('COM_VIRTUEMART_CART_NOTIFY') ?></a>
        <?php elseif (!(VmConfig::get('askprice', true) && empty($tmpPrice))) : ?>
            <?php if (!$product->orderable) : ?>
                <input type="hidden" class="quantity-input js-recalculate" name="quantity[]" data-errStr="<?php echo vmText::_('COM_VIRTUEMART_WRONG_AMOUNT_ADDED'); ?>" value="<?php echo $init; ?>" data-init="<?php echo $init; ?>" data-step="<?php echo $step; ?>" <?php echo $maxOrder; ?> />
            <?php else : ?>
                <label for="<?php echo $quantityFieldId; ?>" class="visually-hidden"><?php echo vmText::_('COM_VIRTUEMART_CART_QUANTITY'); ?></label>
                <span class="quantity-box input-group w-auto<?php echo $qtyClassSuffix; ?>">
                    <button type="button" class="btn btn-secondary quantity-controls quantity-minus">
                        <i class="fas fa-minus" aria-hidden="true"></i>
                        <span class="visually-hidden"><?php echo vmText::_('COM_VM_MINUS'); ?></span>
                    </button>
                    <input type="number" id="<?php echo $quantityFieldId; ?>" class="form-control quantity-input js-recalculate" name="quantity[]" data-errStr="<?php echo vmText::_('COM_VIRTUEMART_WRONG_AMOUNT_ADDED') ?>" value="<?php echo $init; ?>" data-init="<?php echo $init; ?>" data-step="<?php echo $step; ?>" <?php echo $maxOrder; ?> />
                    <button type="button" class="btn btn-secondary quantity-controls quantity-plus">
                        <i class="fas fa-plus" aria-hidden="true"></i>
                        <span class="visually-hidden"><?php echo vmText::_('COM_VM_PLUS'); ?></span>
                    </button>
                </span>
            <?php endif; ?>
            <?php if (!empty($addtoCartButton)) : ?>
                <span class="addtocart-button-container">
                    <?php echo $addtoCartButton; ?>
                </span>
            <?php endif; ?>
            <input type="hidden" name="virtuemart_product_id[]" value="<?php echo $product->virtuemart_product_id; ?>" />
        <?php endif; ?>
    </div>
<?php endif; ?>